/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.common.ast.factory;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintVersion;
import org.neo4j.cypher.internal.parser.common.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.parser.common.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.parser.common.ast.factory.ShowCommandFilterTypes;

public interface ASTExceptionFactory {
    public static final String invalidDropCommand = "Unsupported drop constraint command: Please delete the constraint by name instead";
    public static final String invalidShowBtreeIndexes = "Invalid index type b-tree, please omit the `BTREE` filter.";
    public static final String invalidExistsForShowConstraints = "`SHOW CONSTRAINTS` no longer allows the `EXISTS` keyword, please use `EXIST` or `PROPERTY EXISTENCE` instead.";
    public static final String getInvalidCreateBtreeIndexes = "Invalid index type b-tree, use range, point or text index instead.";
    public static final String periodicCommitNotSupported = "The PERIODIC COMMIT query hint is no longer supported. Please use CALL { ... } IN TRANSACTIONS instead.";
    public static final String namedPatternInInsertNotSupported = "Named patterns are not allowed in `INSERT`. Use `CREATE` instead or remove the name.";
    public static final String colonConjunctionInInsertNotSupported = "Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.";
    public static final String failedToParseFile = "Failed to parse the file expression. Please remember to use quotes for string literals.";

    public Exception syntaxException(String var1, List<String> var2, Exception var3, int var4, int var5, int var6);

    public Exception syntaxException(Exception var1, int var2, int var3, int var4);

    public static String relationshipPatternNotAllowed(ConstraintType type) {
        return String.format("'%s' does not allow relationship patterns", type.description());
    }

    public static String nodePatternNotAllowed(ConstraintType type) {
        return String.format("'%s' does not allow node patterns", type.description());
    }

    public static String onlySinglePropertyAllowed(ConstraintType type) {
        return String.format("Constraint type '%s' does not allow multiple properties", type.description());
    }

    public static String invalidShowFilterType(String command, ShowCommandFilterTypes got) {
        return String.format("Filter type %s is not defined for show %s command.", got.description(), command);
    }

    public static String invalidBriefVerbose(String command) {
        return String.format("`%s` no longer allows the `BRIEF` and `VERBOSE` keywords,\nplease omit `BRIEF` and use `YIELD *` instead of `VERBOSE`.", command);
    }

    public static String invalidCreateIndexType(CreateIndexTypes got) {
        return String.format("Index type %s is not defined for create index command.", got.description());
    }

    public static String checkForInvalidCreateConstraint(ConstraintType type, ConstraintVersion constraintVersion, Boolean containsOn, Boolean moreThanOneProperty) {
        String errorMessageOnRequire = "Invalid constraint syntax, ON should not be used in combination with REQUIRE. Replace ON with FOR.";
        String errorMessageForAssert = "Invalid constraint syntax, FOR should not be used in combination with ASSERT. Replace ASSERT with REQUIRE.";
        String errorMessageForAssertExists = "Invalid constraint syntax, FOR should not be used in combination with ASSERT EXISTS. Replace ASSERT EXISTS with REQUIRE ... IS NOT NULL.";
        String errorMessageOnAssert = "Invalid constraint syntax, ON and ASSERT should not be used. Replace ON with FOR and ASSERT with REQUIRE.";
        String errorMessageOnAssertExists = "Invalid constraint syntax, ON and ASSERT EXISTS should not be used. Replace ON with FOR and ASSERT EXISTS with REQUIRE ... IS NOT NULL.";
        String message = null;
        if (type == ConstraintType.NODE_EXISTS || type == ConstraintType.NODE_IS_NOT_NULL || type == ConstraintType.REL_EXISTS || type == ConstraintType.REL_IS_NOT_NULL) {
            if (moreThanOneProperty.booleanValue() && (type == ConstraintType.NODE_EXISTS || type == ConstraintType.REL_EXISTS)) {
                message = ASTExceptionFactory.onlySinglePropertyAllowed(type);
            } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_2 && containsOn.booleanValue()) {
                message = errorMessageOnRequire;
            } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_1 && !containsOn.booleanValue()) {
                message = errorMessageForAssert;
            } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0 && !containsOn.booleanValue()) {
                message = errorMessageForAssertExists;
            } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_1) {
                message = errorMessageOnAssert;
            } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0) {
                message = errorMessageOnAssertExists;
            }
        } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_2 && containsOn.booleanValue()) {
            message = errorMessageOnRequire;
        } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0 && !containsOn.booleanValue()) {
            message = errorMessageForAssert;
        } else if (constraintVersion == ConstraintVersion.CONSTRAINT_VERSION_0) {
            message = errorMessageOnAssert;
        }
        return message;
    }

    public static String invalidDropConstraint(ConstraintType type, Boolean moreThanOneProperty) {
        String messageFormat = "%s constraints cannot be dropped by schema, please drop by name instead: DROP CONSTRAINT constraint_name. The constraint name can be found using SHOW CONSTRAINTS.";
        return switch (type) {
            case ConstraintType.NODE_UNIQUE -> String.format(messageFormat, "Uniqueness");
            case ConstraintType.NODE_KEY -> String.format(messageFormat, "Node key");
            case ConstraintType.NODE_EXISTS -> {
                if (moreThanOneProperty.booleanValue()) {
                    yield ASTExceptionFactory.onlySinglePropertyAllowed(type);
                }
                yield String.format(messageFormat, "Node property existence");
            }
            case ConstraintType.REL_EXISTS -> {
                if (moreThanOneProperty.booleanValue()) {
                    yield ASTExceptionFactory.onlySinglePropertyAllowed(type);
                }
                yield String.format(messageFormat, "Relationship property existence");
            }
            default -> invalidDropCommand;
        };
    }

    public static String invalidDotsInRemoteAliasName(String name) {
        return String.format("'.' is not a valid character in the remote alias name '%s'. Remote alias names using '.' must be quoted with backticks e.g. `remote.alias`.", name);
    }

    public static String tooManyAliasNameComponents(String name) {
        return String.format("Invalid input `%s` for name. Expected name to contain at most two components separated by `.`.", name);
    }

    public static String tooManyDatabaseNameComponents(String name) {
        return String.format("Invalid input `%s` for database name. Expected name to contain at most one component.", name);
    }

    public static String invalidDefaultScope(String target) {
        return String.format("`ON DEFAULT %s` is not supported. Use `ON HOME %s` instead.", target, target);
    }

    public static String invalidHintIndexType(HintIndexType got) {
        String HINT_TYPES = Arrays.stream(HintIndexType.values()).filter(hintIndexType -> hintIndexType != HintIndexType.BTREE && hintIndexType != HintIndexType.ANY).map(Enum::name).collect(Collectors.collectingAndThen(Collectors.toList(), ASTExceptionFactory.joiningLastDelimiter(", ", " or ")));
        if (got == HintIndexType.BTREE) {
            return String.format("Index type %s is no longer supported for USING index hint. Use %s instead.", got.name(), HINT_TYPES);
        }
        return String.format("Index type %s is not defined for USING index hint. Use %s instead.", got.name(), HINT_TYPES);
    }

    private static Function<List<String>, String> joiningLastDelimiter(String delimiter, String lastDelimiter) {
        return list -> {
            int last = list.size() - 1;
            return String.join((CharSequence)lastDelimiter, String.join((CharSequence)delimiter, list.subList(0, last)), (CharSequence)list.get(last));
        };
    }
}

