/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.BuiltInDelegatingIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.RangeIndexProviderFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class FailingNativeIndexProviderFactory
extends BuiltInDelegatingIndexProviderFactory {
    public static final String INITIAL_STATE_FAILURE_MESSAGE = "Override initial state as failed";
    public static final String POPULATION_FAILURE_MESSAGE = "Fail on update during population";
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("failing-provider", "0.1");
    private final EnumSet<FailureType> failureTypes;

    public FailingNativeIndexProviderFactory(FailureType ... failureTypes) {
        this((AbstractIndexProviderFactory<?>)new RangeIndexProviderFactory(), failureTypes);
    }

    public FailingNativeIndexProviderFactory(AbstractIndexProviderFactory<?> indexProviderFactory, FailureType ... failureTypes) {
        super(indexProviderFactory, DESCRIPTOR);
        if (failureTypes.length == 0) {
            throw new IllegalArgumentException("At least one failure type, otherwise there's no point in this provider");
        }
        this.failureTypes = EnumSet.of(failureTypes[0], Arrays.copyOfRange(failureTypes, 1, failureTypes.length));
    }

    @Override
    public IndexProvider newInstance(ExtensionContext context, BuiltInDelegatingIndexProviderFactory.Dependencies dependencies) {
        final IndexProvider actualProvider = super.newInstance(context, dependencies);
        return new IndexProvider.Delegating(actualProvider){

            public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
                IndexPopulator actualPopulator = actualProvider.getPopulator(descriptor, samplingConfig, bufferFactory, memoryTracker, tokenNameLookup, openOptions, indexingBehaviour);
                if (FailingNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.POPULATION)) {
                    return new IndexPopulator.Delegating(actualPopulator){

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
                            throw new RuntimeException(FailingNativeIndexProviderFactory.POPULATION_FAILURE_MESSAGE);
                        }
                    };
                }
                return actualPopulator;
            }

            public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
                final IndexAccessor actualAccessor = actualProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup, openOptions, readOnly, indexingBehaviour);
                return new IndexAccessor.Delegating(actualAccessor){

                    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
                        IndexUpdater actualUpdater = actualAccessor.newUpdater(mode, cursorContext, parallel);
                        return new DelegatingIndexUpdater(actualUpdater){

                            public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                                if (!FailingNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.SKIP_ONLINE_UPDATES)) {
                                    super.process(update);
                                }
                            }
                        };
                    }
                };
            }

            public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
                return FailingNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? FailingNativeIndexProviderFactory.INITIAL_STATE_FAILURE_MESSAGE : actualProvider.getPopulationFailure(descriptor, cursorContext, openOptions);
            }

            public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
                return FailingNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? InternalIndexState.FAILED : actualProvider.getInitialState(descriptor, cursorContext, openOptions);
            }
        };
    }

    public static enum FailureType {
        POPULATION,
        INITIAL_STATE,
        SKIP_ONLINE_UPDATES;

    }
}

