/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.LazyProcedures;
import org.neo4j.test.TestDatabaseManagementServiceFactory;
import org.neo4j.test.fabric.TestFabricDatabaseManagementServiceFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.FeatureToggles;

public class TestDatabaseManagementServiceBuilder
extends DatabaseManagementServiceBuilder {
    private static final Path EPHEMERAL_PATH = Path.of("/target/test data/neo4j", new String[0]);
    public static final Predicate<ExtensionFactory<?>> INDEX_PROVIDERS_FILTER = extension -> extension instanceof AbstractIndexProviderFactory;
    public static final String FABRIC_IN_EMBEDDED_TEST_TRANSACTIONS_FLAG_NAME = "fabric_in_embedded_test_transactions";
    public static final boolean FABRIC_IN_EMBEDDED_TEST_TRANSACTIONS_DEFAULT_VALUE = false;
    protected FileSystemAbstraction fileSystem;
    protected LogProvider internalLogProvider;
    protected SystemNanoClock clock;
    protected boolean impermanent;
    protected Config fromConfig;
    private boolean noOpSystemGraphInitializer;
    private boolean lazyProcedures = true;

    public TestDatabaseManagementServiceBuilder() {
        super((Path)null);
    }

    public TestDatabaseManagementServiceBuilder(Path homeDirectory) {
        super(homeDirectory);
    }

    public TestDatabaseManagementServiceBuilder(Neo4jLayout layout) {
        super(layout.homeDirectory());
        this.setConfig(GraphDatabaseInternalSettings.databases_root_path, layout.databasesDirectory());
        this.setConfig(GraphDatabaseSettings.transaction_logs_root_path, layout.transactionLogsRootDirectory());
    }

    public TestDatabaseManagementServiceBuilder(DatabaseLayout layout) {
        this(layout.getNeo4jLayout());
        this.setConfig(GraphDatabaseSettings.default_database, layout.getDatabaseName());
    }

    public DatabaseManagementService build() {
        Config cfg = this.config.set(GraphDatabaseSettings.neo4j_home, (Object)this.homeDirectory.toAbsolutePath()).fromConfig(this.fromConfig).build();
        DependencyResolver originalDependencies = this.dependencies;
        if (this.noOpSystemGraphInitializer) {
            this.dependencies = TestDatabaseIdRepository.noOpSystemGraphInitializer((DependencyResolver)this.dependencies, (Config)cfg);
        }
        if (this.lazyProcedures) {
            Dependencies dependencyWrapper = new Dependencies(this.dependencies);
            dependencyWrapper.satisfyDependency((Object)new LazyProcedures());
            this.dependencies = dependencyWrapper;
        }
        DatabaseManagementService dbms = this.newDatabaseManagementService(cfg, this.databaseDependencies());
        this.dependencies = originalDependencies;
        return dbms;
    }

    protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
        TestDatabaseManagementServiceFactory factory = this.fabricInEmbeddedTestTransactionsEnabled() ? new TestFabricDatabaseManagementServiceFactory(this.getDbmsInfo(config), this.getEditionFactory(config), this.impermanent, this.fileSystem, this.clock, this.internalLogProvider, config) : new TestDatabaseManagementServiceFactory(this.getDbmsInfo(config), this.getEditionFactory(config), this.impermanent, this.fileSystem, this.clock, this.internalLogProvider);
        return factory.build(this.augmentConfig(config), (ExternalDependencies)GraphDatabaseDependencies.newDependencies((ExternalDependencies)dependencies));
    }

    private boolean fabricInEmbeddedTestTransactionsEnabled() {
        return FeatureToggles.flag(TestDatabaseManagementServiceBuilder.class, (String)FABRIC_IN_EMBEDDED_TEST_TRANSACTIONS_FLAG_NAME, (boolean)false);
    }

    protected Config augmentConfig(Config config) {
        return Config.newBuilder().fromConfig(config).setDefault(GraphDatabaseSettings.pagecache_memory, (Object)"8m").setDefault(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.kibiBytes((long)128L)).setDefault(BoltConnector.enabled, (Object)Boolean.FALSE).setDefault(GraphDatabaseInternalSettings.dump_diagnostics, (Object)false).setDefault(GraphDatabaseInternalSettings.track_tx_statement_close, (Object)true).setDefault(GraphDatabaseInternalSettings.trace_tx_statements, (Object)true).setDefault(GraphDatabaseInternalSettings.track_cursor_close, (Object)true).setDefault(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period, (Object)0).setDefault(GraphDatabaseInternalSettings.netty_server_shutdown_timeout, (Object)Duration.ofSeconds(3L)).setDefault(GraphDatabaseInternalSettings.additional_lock_verification, (Object)true).setDefault(GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, (Object)true).build();
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public Path getHomeDirectory() {
        return this.homeDirectory;
    }

    public TestDatabaseManagementServiceBuilder setFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setDatabaseRootDirectory(Path storeDir) {
        this.homeDirectory = storeDir;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setInternalLogProvider(LogProvider internalLogProvider) {
        this.internalLogProvider = internalLogProvider;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setClock(SystemNanoClock clock) {
        this.clock = clock;
        return this;
    }

    private TestDatabaseManagementServiceBuilder addExtensions(Iterable<ExtensionFactory<?>> extensions) {
        for (ExtensionFactory<?> extension : extensions) {
            this.extensions.add(extension);
        }
        return this;
    }

    public TestDatabaseManagementServiceBuilder addExtension(ExtensionFactory<?> extension) {
        return this.addExtensions(Collections.singletonList(extension));
    }

    public TestDatabaseManagementServiceBuilder setExtensions(Iterable<ExtensionFactory<?>> newExtensions) {
        this.extensions.clear();
        this.addExtensions(newExtensions);
        return this;
    }

    public TestDatabaseManagementServiceBuilder removeExtensions(Predicate<ExtensionFactory<?>> toRemove) {
        this.extensions.removeIf(toRemove);
        return this;
    }

    public TestDatabaseManagementServiceBuilder impermanent() {
        this.impermanent = true;
        if (this.homeDirectory == null) {
            this.homeDirectory = EPHEMERAL_PATH;
        }
        return this;
    }

    public TestDatabaseManagementServiceBuilder setConfig(Config fromConfig) {
        if (this.fromConfig != null) {
            throw new IllegalStateException("You can only set config once.");
        }
        this.fromConfig = fromConfig;
        return this;
    }

    public DatabaseManagementServiceBuilder setConfigRaw(Map<String, String> raw) {
        this.config.setRaw(raw);
        return this;
    }

    public TestDatabaseManagementServiceBuilder useLazyProcedures(boolean useLazyProcedures) {
        this.lazyProcedures = useLazyProcedures;
        return this;
    }

    public TestDatabaseManagementServiceBuilder noOpSystemGraphInitializer() {
        this.noOpSystemGraphInitializer = true;
        return this;
    }

    public TestDatabaseManagementServiceBuilder setExternalDependencies(DependencyResolver dependencies) {
        return (TestDatabaseManagementServiceBuilder)super.setExternalDependencies(dependencies);
    }

    public TestDatabaseManagementServiceBuilder setMonitors(Monitors monitors) {
        return (TestDatabaseManagementServiceBuilder)super.setMonitors(monitors);
    }

    public TestDatabaseManagementServiceBuilder setUserLogProvider(LogProvider logProvider) {
        return (TestDatabaseManagementServiceBuilder)super.setUserLogProvider(logProvider);
    }

    public TestDatabaseManagementServiceBuilder addURLAccessRule(String protocol, URLAccessRule rule) {
        return (TestDatabaseManagementServiceBuilder)super.addURLAccessRule(protocol, rule);
    }

    public <T> TestDatabaseManagementServiceBuilder setConfig(Setting<T> setting, T value) {
        return (TestDatabaseManagementServiceBuilder)super.setConfig(setting, value);
    }

    public TestDatabaseManagementServiceBuilder setConfig(Map<Setting<?>, Object> config) {
        return (TestDatabaseManagementServiceBuilder)super.setConfig(config);
    }

    public <T> TestDatabaseManagementServiceBuilder overrideDefaultSetting(Setting<T> setting, T value) {
        this.config.setDefault(setting, value);
        return this;
    }
}

