/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.time.Duration;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.Locker;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.time.SystemNanoClock;

public class TestDatabaseManagementServiceFactory
extends DatabaseManagementServiceFactory {
    private final boolean impermanent;
    private FileSystemAbstraction fileSystem;
    private LogProvider internalLogProvider;
    private final SystemNanoClock clock;

    public TestDatabaseManagementServiceFactory(DatabaseInfo databaseInfo, Function<GlobalModule, AbstractEditionModule> editionFactory, boolean impermanent, FileSystemAbstraction fileSystem, SystemNanoClock clock, LogProvider internalLogProvider) {
        super(databaseInfo, editionFactory);
        this.impermanent = impermanent;
        this.fileSystem = fileSystem;
        this.clock = clock;
        this.internalLogProvider = internalLogProvider;
    }

    protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
        config.setIfNotSet(GraphDatabaseSettings.shutdown_transaction_end_timeout, (Object)Duration.ZERO);
        if (this.impermanent) {
            config.set(GraphDatabaseSettings.ephemeral_lucene, (Object)true);
            config.setIfNotSet(GraphDatabaseSettings.keep_logical_logs, (Object)"1 files");
            return new ImpermanentTestDatabaseGlobalModule(config, dependencies, this.databaseInfo);
        }
        return new TestDatabaseGlobalModule(config, dependencies, this.databaseInfo);
    }

    private static class ImpermanentLockerService
    implements FileLockerService {
        private ImpermanentLockerService() {
        }

        public Locker createStoreLocker(FileSystemAbstraction fileSystem, Neo4jLayout storeLayout) {
            return new Locker(fileSystem, storeLayout.storeLockFile());
        }

        public Locker createDatabaseLocker(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
            return new Locker(fileSystem, databaseLayout.databaseLockFile());
        }
    }

    private class ImpermanentTestDatabaseGlobalModule
    extends TestDatabaseGlobalModule {
        ImpermanentTestDatabaseGlobalModule(Config config, ExternalDependencies dependencies, DatabaseInfo databaseInfo) {
            super(config, dependencies, databaseInfo);
        }

        @Override
        protected FileSystemAbstraction createNewFileSystem() {
            return new EphemeralFileSystemAbstraction();
        }

        protected FileLockerService createFileLockerService() {
            return new ImpermanentLockerService();
        }
    }

    class TestDatabaseGlobalModule
    extends GlobalModule {
        TestDatabaseGlobalModule(Config config, ExternalDependencies dependencies, DatabaseInfo databaseInfo) {
            super(config, databaseInfo, dependencies);
        }

        protected FileSystemAbstraction createFileSystemAbstraction() {
            if (TestDatabaseManagementServiceFactory.this.fileSystem != null) {
                return TestDatabaseManagementServiceFactory.this.fileSystem;
            }
            return this.createNewFileSystem();
        }

        protected FileSystemAbstraction createNewFileSystem() {
            return super.createFileSystemAbstraction();
        }

        protected LogService createLogService(LogProvider userLogProvider) {
            if (TestDatabaseManagementServiceFactory.this.internalLogProvider == null) {
                if (!TestDatabaseManagementServiceFactory.this.impermanent) {
                    return super.createLogService(userLogProvider);
                }
                TestDatabaseManagementServiceFactory.this.internalLogProvider = NullLogProvider.getInstance();
            }
            return new SimpleLogService(userLogProvider, TestDatabaseManagementServiceFactory.this.internalLogProvider);
        }

        protected SystemNanoClock createClock() {
            return TestDatabaseManagementServiceFactory.this.clock != null ? TestDatabaseManagementServiceFactory.this.clock : super.createClock();
        }
    }
}

