/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.test.rule.RetryHandler;

public abstract class DatabaseRule
extends ExternalResource
implements GraphDatabaseAPI {
    private GraphDatabaseBuilder databaseBuilder;
    private GraphDatabaseAPI database;
    private File databaseDir;
    private Supplier<Statement> statementSupplier;
    private boolean startEagerly = true;
    private Map<Setting<?>, String> config;
    private final Monitors monitors = new Monitors();

    public DatabaseRule startLazily() {
        this.startEagerly = false;
        return this;
    }

    public <T> T when(Function<GraphDatabaseService, T> function) {
        return function.apply((GraphDatabaseService)this.getGraphDatabaseAPI());
    }

    public void executeAndCommit(Consumer<? super GraphDatabaseService> consumer) {
        this.transaction(t -> {
            consumer.accept((GraphDatabaseService)t);
            return null;
        }, true);
    }

    public <T> T executeAndCommit(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, true);
    }

    public <T> T executeAndRollback(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, false);
    }

    public <FROM, TO> Function<FROM, TO> tx(Function<FROM, TO> function) {
        return from -> {
            Function<GraphDatabaseService, Object> inner = graphDb -> function.apply(from);
            return this.executeAndCommit(inner);
        };
    }

    private <T> T transaction(Function<? super GraphDatabaseService, T> function, boolean commit) {
        return DatabaseRule.tx((GraphDatabaseService)this.getGraphDatabaseAPI(), commit, RetryHandler.NO_RETRY, function);
    }

    public static void tx(GraphDatabaseService db, RetryHandler retry, Consumer<? super GraphDatabaseService> transaction) {
        Function<GraphDatabaseService, Void> voidFunction = _db -> {
            transaction.accept((GraphDatabaseService)_db);
            return null;
        };
        DatabaseRule.tx(db, true, retry, voidFunction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T tx(GraphDatabaseService db, boolean commit, RetryHandler retry, Function<? super GraphDatabaseService, T> transaction) {
        while (true) {
            try (Transaction tx = db.beginTx();){
                GraphDatabaseService result = transaction.apply(db);
                if (commit) {
                    tx.success();
                }
                GraphDatabaseService t = result;
                return (T)t;
            }
            catch (Throwable t2) {
                if (retry.retryOn(t2)) continue;
                throw t2;
            }
            break;
        }
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query);
    }

    public Result execute(String query, long timeout, TimeUnit unit) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query, timeout, unit);
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query, parameters);
    }

    public Result execute(String query, Map<String, Object> parameters, long timeout, TimeUnit unit) throws QueryExecutionException {
        return this.getGraphDatabaseAPI().execute(query, parameters, timeout, unit);
    }

    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext);
    }

    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext, long timeout, TimeUnit unit) {
        return this.getGraphDatabaseAPI().beginTransaction(type, loginContext, timeout, unit);
    }

    public Transaction beginTx() {
        return this.getGraphDatabaseAPI().beginTx();
    }

    public Transaction beginTx(long timeout, TimeUnit timeUnit) {
        return this.getGraphDatabaseAPI().beginTx(timeout, timeUnit);
    }

    public Node createNode(Label ... labels) {
        return this.getGraphDatabaseAPI().createNode(labels);
    }

    public Node getNodeById(long id) {
        return this.getGraphDatabaseAPI().getNodeById(id);
    }

    @Deprecated
    public IndexManager index() {
        return this.getGraphDatabaseAPI().index();
    }

    public Schema schema() {
        return this.getGraphDatabaseAPI().schema();
    }

    protected void before() {
        this.create();
        if (this.startEagerly) {
            this.ensureStarted(new String[0]);
        }
    }

    protected void after(boolean success) {
        this.shutdown(success);
    }

    private void create() {
        this.createResources();
        try {
            GraphDatabaseFactory factory = this.newFactory();
            factory.setMonitors(this.monitors);
            this.configure(factory);
            this.databaseBuilder = this.newBuilder(factory);
            this.configure(this.databaseBuilder);
        }
        catch (RuntimeException e) {
            this.deleteResources();
            throw e;
        }
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    protected void deleteResources() {
    }

    protected void createResources() {
    }

    protected abstract GraphDatabaseFactory newFactory();

    protected abstract GraphDatabaseBuilder newBuilder(GraphDatabaseFactory var1);

    protected void configure(GraphDatabaseFactory databaseFactory) {
    }

    protected void configure(GraphDatabaseBuilder builder) {
        if (this.config != null) {
            for (Map.Entry<Setting<?>, String> setting : this.config.entrySet()) {
                builder.setConfig(setting.getKey(), setting.getValue());
            }
        }
    }

    public GraphDatabaseBuilder setConfig(Setting<?> setting, String value) {
        return this.databaseBuilder.setConfig(setting, value);
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        this.ensureStarted(new String[0]);
        return this.database;
    }

    public synchronized void ensureStarted(String ... additionalConfig) {
        if (this.database == null) {
            this.applyConfigChanges(additionalConfig);
            this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
            this.databaseDir = this.database.databaseDirectory();
            this.statementSupplier = (Supplier)this.resolveDependency(ThreadToStatementContextBridge.class);
        }
    }

    public DatabaseRule withSetting(Setting<?> key, String value) {
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.config.put(key, value);
        return this;
    }

    public DatabaseRule withConfiguration(Map<Setting<?>, String> configuration) {
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.config.putAll(configuration);
        return this;
    }

    public GraphDatabaseAPI restartDatabase(String ... configChanges) throws IOException {
        return this.restartDatabase(RestartAction.EMPTY, configChanges);
    }

    public GraphDatabaseAPI restartDatabase(RestartAction action, String ... configChanges) throws IOException {
        FileSystemAbstraction fs = this.resolveDependency(FileSystemAbstraction.class);
        this.database.shutdown();
        action.run(fs, this.databaseDir);
        this.database = null;
        this.applyConfigChanges(configChanges);
        return this.getGraphDatabaseAPI();
    }

    private void applyConfigChanges(String[] configChanges) {
        this.databaseBuilder.setConfig(MapUtil.stringMap((String[])configChanges));
    }

    public void shutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean deleteResources) {
        this.statementSupplier = null;
        try {
            if (this.database != null) {
                this.database.shutdown();
            }
        }
        finally {
            if (deleteResources) {
                this.deleteResources();
            }
            this.database = null;
        }
    }

    public void shutdownAndKeepStore() {
        this.shutdown(false);
    }

    public <T> T resolveDependency(Class<T> type) {
        return (T)this.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(type);
    }

    public Statement statement() {
        this.ensureStarted(new String[0]);
        return this.statementSupplier.get();
    }

    public KernelTransaction transaction() {
        this.ensureStarted(new String[0]);
        return ((ThreadToStatementContextBridge)this.database.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    public DependencyResolver getDependencyResolver() {
        return this.database.getDependencyResolver();
    }

    public StoreId storeId() {
        return this.database.storeId();
    }

    public File databaseDirectory() {
        return this.database.databaseDirectory();
    }

    public String getDatabaseDirAbsolutePath() {
        return this.databaseDirectory().getAbsolutePath();
    }

    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.database.validateURLAccess(url);
    }

    public Node createNode() {
        return this.database.createNode();
    }

    public Long createNodeId() {
        return this.database.createNodeId();
    }

    public Relationship getRelationshipById(long id) {
        return this.database.getRelationshipById(id);
    }

    public ResourceIterable<Node> getAllNodes() {
        return this.database.getAllNodes();
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        return this.database.getAllRelationships();
    }

    public ResourceIterable<Label> getAllLabelsInUse() {
        return this.database.getAllLabelsInUse();
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.database.getAllRelationshipTypesInUse();
    }

    public ResourceIterable<Label> getAllLabels() {
        return this.database.getAllLabels();
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypes() {
        return this.database.getAllRelationshipTypes();
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        return this.database.getAllPropertyKeys();
    }

    public ResourceIterator<Node> findNodes(Label label, String key, Object value) {
        return this.database.findNodes(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        return this.database.findNodes(label, key1, value1, key2, value2);
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        return this.database.findNodes(label, key1, value1, key2, value2, key3, value3);
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        return this.database.findNodes(label, propertyValues);
    }

    public ResourceIterator<Node> findNodes(Label label, String key, String template, StringSearchMode searchMode) {
        return this.database.findNodes(label, key, template, searchMode);
    }

    public Node findNode(Label label, String key, Object value) {
        return this.database.findNode(label, key, value);
    }

    public ResourceIterator<Node> findNodes(Label label) {
        return this.database.findNodes(label);
    }

    public boolean isAvailable(long timeout) {
        return this.database.isAvailable(timeout);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.database.registerTransactionEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.database.unregisterTransactionEventHandler(handler);
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.database.registerKernelEventHandler(handler);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.database.unregisterKernelEventHandler(handler);
    }

    public TraversalDescription traversalDescription() {
        return this.database.traversalDescription();
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return this.database.bidirectionalTraversalDescription();
    }

    public static interface RestartAction {
        public static final RestartAction EMPTY = (fs, storeDirectory) -> {};

        public void run(FileSystemAbstraction var1, File var2) throws IOException;
    }
}

