/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.util.Preconditions;

public class TestDatabaseIdRepository
implements DatabaseIdRepository {
    private final String defaultDatabaseName;
    private final Set<String> filterSet;
    private final ConcurrentHashMap<NormalizedDatabaseName, NamedDatabaseId> cache = new ConcurrentHashMap<NormalizedDatabaseName, NamedDatabaseId>(Map.of(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID));

    public TestDatabaseIdRepository() {
        this("neo4j");
    }

    public TestDatabaseIdRepository(Config config) {
        this((String)config.get(GraphDatabaseSettings.initial_default_database));
    }

    public TestDatabaseIdRepository(String defaultDbName) {
        this.filterSet = new CopyOnWriteArraySet<String>();
        this.defaultDatabaseName = defaultDbName;
    }

    public NamedDatabaseId defaultDatabase() {
        return this.getRaw(this.defaultDatabaseName);
    }

    public NamedDatabaseId getRaw(String databaseName) {
        Optional<NamedDatabaseId> databaseIdOpt = this.getByName(databaseName);
        Preconditions.checkState((boolean)databaseIdOpt.isPresent(), (String)(this.getClass().getSimpleName() + " should always produce a " + NamedDatabaseId.class.getSimpleName() + " for any database name"));
        return databaseIdOpt.get();
    }

    public void filter(String databaseName) {
        this.filterSet.add(databaseName);
    }

    public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
        this.cache.putIfAbsent(databaseName, new NamedDatabaseId(databaseName.name(), UUID.randomUUID()));
        NamedDatabaseId id = this.cache.get(databaseName);
        return this.filterSet.contains(id.name()) ? Optional.empty() : Optional.of(id);
    }

    public Optional<NamedDatabaseId> getByName(String databaseName) {
        return this.getByName(new NormalizedDatabaseName(databaseName));
    }

    public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
        Optional<NamedDatabaseId> id = this.cache.values().stream().filter((? super T v) -> v.databaseId().equals((Object)databaseId)).findFirst();
        Boolean uuidIsFiltered = id.map(i -> this.filterSet.contains(i.name())).orElse(false);
        return uuidIsFiltered != false ? Optional.empty() : id;
    }

    public Optional<NamedDatabaseId> getOwningDatabaseId(DatabaseId databaseId) {
        Optional<NamedDatabaseId> id = this.cache.values().stream().filter((? super T v) -> v.databaseId().equals((Object)databaseId)).findFirst();
        Boolean uuidIsFiltered = id.map(i -> this.filterSet.contains(i.name())).orElse(false);
        return uuidIsFiltered != false ? Optional.empty() : id;
    }
}

