/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.QueryType;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.virtual.MapValue;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectorySupportExtension.class})
class SecurityProcedureQueryTypeTest {
    @Inject
    static TestDirectory testDirectory;
    private static FabricPlanner planner;
    private static DatabaseManagementService databaseManagementService;

    SecurityProcedureQueryTypeTest() {
    }

    @BeforeAll
    static void beforeAll() {
        databaseManagementService = new TestDatabaseManagementServiceBuilder(testDirectory.homePath()).setConfig(GraphDatabaseSettings.auth_enabled, (Object)true).build();
        DependencyResolver dependencyResolver = ((GraphDatabaseFacade)databaseManagementService.database("system")).getDependencyResolver();
        planner = (FabricPlanner)dependencyResolver.resolveDependency(FabricPlanner.class);
    }

    @AfterAll
    static void afterAll() {
        databaseManagementService.shutdown();
    }

    @ParameterizedTest(name="statement {0} should have queryType {1}")
    @MethodSource(value={"procedures"})
    void securityProcedure(String statement, QueryType queryType) {
        FabricPlanner.PlannerInstance instance = planner.instance(statement, MapValue.EMPTY, "system");
        Assertions.assertThat((Object)instance.plan().queryType()).isEqualTo((Object)queryType);
    }

    static List<Arguments> procedures() {
        return List.of(Arguments.of((Object[])new Object[]{"CALL dbms.security.listUsers()", QueryType.READ()}), Arguments.of((Object[])new Object[]{"CALL dbms.security.createUser('Tobias', 'secret')", QueryType.WRITE()}), Arguments.of((Object[])new Object[]{"CALL dbms.security.changePassword('newSecret')", QueryType.WRITE()}), Arguments.of((Object[])new Object[]{"CALL dbms.security.deleteUser('Tobias')", QueryType.WRITE()}), Arguments.of((Object[])new Object[]{"CALL dbms.showCurrentUser()", QueryType.READ()}));
    }
}

