/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.header;

import com.google.code.mojo.license.header.HeaderDefinition;
import com.google.code.mojo.license.util.FileUtils;
import com.google.code.mojo.license.util.StringUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class Header {
    private final URL location;
    private final String headerContent;
    private final String headerContentOneLine;
    private String[] lines;
    private static final Map<String, String> EMPTY_PROPERTIES = new HashMap<String, String>(0);

    public Header(URL location, Map<String, String> properties) {
        if (location == null) {
            throw new IllegalArgumentException("Cannot read license template header file with a null location");
        }
        if (properties == null) {
            properties = EMPTY_PROPERTIES;
        }
        this.location = location;
        try {
            this.headerContent = FileUtils.read(location, properties);
            this.lines = this.headerContent.replace("\r", "").split("\n");
            this.headerContentOneLine = FileUtils.remove(this.headerContent, " ", "\t", "\r", "\n");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + location + ". Cause: " + e.getMessage(), e);
        }
    }

    public String asString() {
        return this.headerContent;
    }

    public String asOneLineString() {
        return this.headerContentOneLine;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public URL getLocation() {
        return this.location;
    }

    public String eol(boolean unix) {
        return unix ? "\n" : "\r\n";
    }

    public String buildForDefinition(HeaderDefinition type, boolean unix) {
        StringBuilder newHeader = new StringBuilder();
        if (this.notEmpty(type.getFirstLine())) {
            newHeader.append(type.getFirstLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        for (String line : this.getLines()) {
            String str = type.getBeforeEachLine().replace("EOL", this.eol(unix)) + line;
            newHeader.append(StringUtils.rtrim(str));
            newHeader.append(this.eol(unix));
        }
        if (this.notEmpty(type.getEndLine())) {
            newHeader.append(type.getEndLine().replace("EOL", this.eol(unix)));
            newHeader.append(this.eol(unix));
        }
        return newHeader.toString();
    }

    public String toString() {
        return this.asString();
    }

    public String[] getLines() {
        return this.lines;
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }
}

