/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.mojo.license.header;

import com.google.code.mojo.license.header.HeaderDefinition;
import com.mycila.xmltool.CallBack;
import com.mycila.xmltool.XMLTag;
import java.util.HashMap;
import java.util.Map;

public final class AdditionalHeaderDefinition {
    private final Map<String, HeaderDefinition> definitions = new HashMap<String, HeaderDefinition>();

    public AdditionalHeaderDefinition(XMLTag doc) {
        if (doc == null) {
            throw new IllegalArgumentException("The header definition XML document cannot be null");
        }
        doc.gotoRoot().forEachChild(new CallBack(){

            public void execute(XMLTag doc) {
                String type = doc.getCurrentTagName().toLowerCase();
                HeaderDefinition definition = (HeaderDefinition)AdditionalHeaderDefinition.this.definitions.get(type);
                if (definition == null) {
                    definition = new HeaderDefinition(type);
                    AdditionalHeaderDefinition.this.definitions.put(type, definition);
                }
                doc.forEachChild((CallBack)new FeedProperty(definition));
                definition.validate();
            }
        });
    }

    public Map<String, HeaderDefinition> getDefinitions() {
        return this.definitions;
    }

    private static final class FeedProperty
    implements CallBack {
        private final HeaderDefinition definition;

        private FeedProperty(HeaderDefinition definition) {
            this.definition = definition;
        }

        public void execute(XMLTag xmlDocument) {
            String value = xmlDocument.getText();
            if ("".equals(value)) {
                value = xmlDocument.getCDATA();
            }
            this.definition.setPropertyFromString(xmlDocument.getCurrentTagName(), value);
        }
    }
}

