/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response.format;

import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.server.queryapi.response.format.CypherTypes;
import org.neo4j.server.queryapi.response.format.View;
import org.neo4j.values.storable.DurationValue;

public final class DefaultResponseModule
extends SimpleModule {
    private static final long serialVersionUID = -6600328341718439212L;
    private final TypeSystem typeSystem;
    private final View view;

    public DefaultResponseModule(TypeSystem typeSystem, View view) {
        this.typeSystem = typeSystem;
        this.view = view;
        this.addSerializer(Record.class, (JsonSerializer)new RecordSerializer());
        this.addSerializer(Value.class, (JsonSerializer)new ValueSerializer());
        this.addSerializer(SummaryCounters.class, (JsonSerializer)new SummaryCountersSerializer());
        this.addSerializer(Plan.class, (JsonSerializer)new QueryPlanSerializer());
        this.addSerializer(ProfiledPlan.class, (JsonSerializer)new ProfiledPlanSerializer());
        this.addSerializer(Notification.class, (JsonSerializer)new NotificationSerializer());
        this.setMixInAnnotation(InputPosition.class, InputPositionMixIn.class);
        this.setMixInAnnotation(Neo4jException.class, Neo4jExceptionMixIn.class);
    }

    private static final class RecordSerializer
    extends StdSerializer<Record> {
        private static final long serialVersionUID = 8594507829627684699L;

        RecordSerializer() {
            super(Record.class);
        }

        public void serialize(Record record, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            JsonSerializer valueSerializer = serializerProvider.findValueSerializer(Value.class);
            for (Value value : record.values()) {
                valueSerializer.serialize((Object)value, json, serializerProvider);
            }
        }
    }

    final class ValueSerializer
    extends StdSerializer<Value> {
        private static final long serialVersionUID = -5914605165093400044L;
        private static final Map<Integer, String> SRID_MAPPING = Map.of(7203, "cartesian", 9157, "cartesian-3d", 4326, "wgs-84", 4979, "wgs-84-3d");
        private static final Map<Integer, String> FORMAT_MAPPING = Map.of(7203, "http://spatialreference.org/ref/sr-org/%d/ogcwkt/", 9157, "http://spatialreference.org/ref/sr-org/%d/ogcwkt/", 4326, "http://spatialreference.org/ref/epsg/%d/ogcwkt/", 4979, "http://spatialreference.org/ref/epsg/%d/ogcwkt/");
        private final Map<Type, CypherTypes> typeToNames;

        ValueSerializer() {
            super(Value.class);
            this.typeToNames = new HashMap<Type, CypherTypes>();
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.BYTES(), CypherTypes.Base64);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.BOOLEAN(), CypherTypes.Boolean);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.INTEGER(), CypherTypes.Integer);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.NULL(), CypherTypes.Null);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.FLOAT(), CypherTypes.Float);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.STRING(), CypherTypes.String);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.DATE(), CypherTypes.Date);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.TIME(), CypherTypes.Time);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.LOCAL_TIME(), CypherTypes.LocalTime);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.DATE_TIME(), CypherTypes.DateTime);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.LOCAL_DATE_TIME(), CypherTypes.LocalDateTime);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.DURATION(), CypherTypes.Duration);
            this.typeToNames.put(DefaultResponseModule.this.typeSystem.POINT(), CypherTypes.Point);
        }

        public void serialize(Value value, JsonGenerator json, SerializerProvider serializers) throws IOException {
            if (value.hasType(DefaultResponseModule.this.typeSystem.LIST())) {
                if (DefaultResponseModule.this.view.equals((Object)View.TYPED_JSON)) {
                    json.writeStartObject();
                    json.writeStringField("$type", CypherTypes.List.getValue());
                    json.writeFieldName("_value");
                    json.writeStartArray();
                } else {
                    json.writeStartArray();
                }
                for (Value element : value.values()) {
                    this.serialize(element, json, serializers);
                }
                json.writeEndArray();
                if (DefaultResponseModule.this.view.equals((Object)View.TYPED_JSON)) {
                    json.writeEndObject();
                }
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.MAP()) && !value.hasType(DefaultResponseModule.this.typeSystem.NODE()) && !value.hasType(DefaultResponseModule.this.typeSystem.RELATIONSHIP())) {
                if (DefaultResponseModule.this.view.equals((Object)View.TYPED_JSON)) {
                    json.writeStartObject();
                    json.writeStringField("$type", CypherTypes.Map.getValue());
                    json.writeFieldName("_value");
                }
                json.writeStartObject();
                for (String key : value.keys()) {
                    json.writeFieldName(key);
                    this.serialize(value.get(key), json, serializers);
                }
                json.writeEndObject();
                if (DefaultResponseModule.this.view.equals((Object)View.TYPED_JSON)) {
                    json.writeEndObject();
                }
            } else if (DefaultResponseModule.this.view == View.PLAIN_JSON) {
                this.renderSimpleValue(value, json, serializers);
            } else if (DefaultResponseModule.this.view == View.TYPED_JSON) {
                this.renderNewFormat(value, json, serializers);
            }
        }

        private void renderNewFormat(Value value, JsonGenerator json, SerializerProvider serializers) throws IOException {
            if (this.typeToNames.containsKey(value.type())) {
                CypherTypes cypherType = this.typeToNames.get(value.type());
                json.writeStartObject();
                if (value.hasType(DefaultResponseModule.this.typeSystem.DATE_TIME())) {
                    if (value.asZonedDateTime().getZone().normalized() instanceof ZoneOffset) {
                        json.writeStringField("$type", "OffsetDateTime");
                    } else {
                        json.writeStringField("$type", "ZonedDateTime");
                    }
                    json.writeStringField("_value", this.typeToNames.get(value.type()).getWriter().apply(value));
                } else {
                    json.writeStringField("$type", cypherType.getValue());
                    json.writeFieldName("_value");
                    if (cypherType.equals((Object)CypherTypes.Null)) {
                        json.writeNull();
                    } else if (cypherType.equals((Object)CypherTypes.Boolean)) {
                        json.writeBoolean(value.asBoolean());
                    } else {
                        json.writeString(cypherType.getWriter().apply(value));
                    }
                }
                json.writeEndObject();
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.POINT())) {
                this.renderPoint(value, json, true);
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.NODE())) {
                this.writeNode(value.asNode(), json, serializers, DefaultResponseModule.this.view);
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.RELATIONSHIP())) {
                this.writeRelationship(value.asRelationship(), json, serializers, DefaultResponseModule.this.view);
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.PATH())) {
                json.writeStartObject();
                json.writeStringField("$type", CypherTypes.Path.getValue());
                json.writeFieldName("_value");
                json.writeStartArray();
                Path path = value.asPath();
                for (Path.Segment element : path) {
                    this.writeNode(element.start(), json, serializers, DefaultResponseModule.this.view);
                    this.writeRelationship(element.relationship(), json, serializers, DefaultResponseModule.this.view);
                }
                this.writeNode(path.end(), json, serializers, DefaultResponseModule.this.view);
                json.writeEndArray();
                json.writeEndObject();
            } else {
                throw new UnsupportedOperationException("Type " + value.type().name() + " is not supported as a column value");
            }
        }

        private void renderPoint(Value value, JsonGenerator json, boolean newFormat) throws IOException {
            Point point = value.asPoint();
            json.writeStartObject();
            json.writeStringField(newFormat ? "$type" : "type", "Point");
            if (newFormat) {
                json.writeFieldName("_value");
                json.writeStartObject();
            }
            json.writeArrayFieldStart("coordinates");
            json.writeNumber(point.x());
            json.writeNumber(point.y());
            if (!Double.isNaN(point.z())) {
                json.writeNumber(point.z());
            }
            json.writeEndArray();
            json.writeObjectFieldStart("crs");
            json.writeNumberField("srid", point.srid());
            json.writeStringField("name", SRID_MAPPING.getOrDefault(point.srid(), "n/a"));
            json.writeStringField("type", "link");
            if (FORMAT_MAPPING.containsKey(point.srid())) {
                json.writeObjectFieldStart("properties");
                json.writeStringField("href", FORMAT_MAPPING.get(point.srid()).formatted(point.srid()));
                json.writeStringField("type", "ogcwkt");
                json.writeEndObject();
            }
            json.writeEndObject();
            if (newFormat) {
                json.writeEndObject();
            }
            json.writeEndObject();
        }

        private void renderSimpleValue(Value value, JsonGenerator json, SerializerProvider serializers) throws IOException {
            if (value == null || value.isNull()) {
                json.writeNull();
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.BOOLEAN())) {
                json.writeBoolean(value.asBoolean());
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.STRING())) {
                json.writeString(value.asString());
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.INTEGER())) {
                json.writeNumber(value.asLong());
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.FLOAT())) {
                try {
                    json.writeNumber(value.asFloat());
                }
                catch (LossyCoercion e) {
                    json.writeNumber(value.asDouble());
                }
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.DATE())) {
                json.writeString(value.asLocalDate().format(DateTimeFormatter.ISO_DATE));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.DATE_TIME())) {
                json.writeString(value.asZonedDateTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.DURATION())) {
                json.writeString(DurationValue.parse((CharSequence)value.asIsoDuration().toString()).toString());
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.LOCAL_DATE_TIME())) {
                json.writeString(value.asLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.LOCAL_TIME())) {
                json.writeString(value.asLocalTime().format(DateTimeFormatter.ISO_LOCAL_TIME));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.TIME())) {
                json.writeString(value.asOffsetTime().format(DateTimeFormatter.ISO_OFFSET_TIME));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.NODE())) {
                Node node = value.asNode();
                this.writeNode(node, json, serializers, View.PLAIN_JSON);
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.BYTES())) {
                json.writeString(Base64.getEncoder().encodeToString(value.asByteArray()));
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.RELATIONSHIP())) {
                Relationship rel = value.asRelationship();
                this.writeRelationship(rel, json, serializers, View.PLAIN_JSON);
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.PATH())) {
                json.writeStartArray();
                Path path = value.asPath();
                for (Path.Segment element : path) {
                    this.writeNode(element.start(), json, serializers, DefaultResponseModule.this.view);
                    this.writeRelationship(element.relationship(), json, serializers, View.PLAIN_JSON);
                }
                this.writeNode(path.end(), json, serializers, View.PLAIN_JSON);
                json.writeEndArray();
            } else if (value.hasType(DefaultResponseModule.this.typeSystem.POINT())) {
                json.writeString(CypherTypes.Point.getWriter().apply(value));
            } else {
                throw new UnsupportedOperationException("Type " + value.type().name() + " is not supported as a column value");
            }
        }

        private void writeEntityProperties(String propLabel, Entity node, JsonGenerator json, SerializerProvider serializers) throws IOException {
            json.writeFieldName(propLabel);
            json.writeStartObject();
            for (String property : node.keys()) {
                json.writeFieldName(property);
                this.serialize(node.get(property), json, serializers);
            }
            json.writeEndObject();
        }

        private void writeNode(Node node, JsonGenerator json, SerializerProvider serializers, View view) throws IOException {
            json.writeStartObject();
            if (view.equals((Object)View.TYPED_JSON)) {
                json.writeStringField("$type", CypherTypes.Node.name());
                json.writeFieldName("_value");
                json.writeStartObject();
            }
            json.writeStringField(View.elementId(view), node.elementId());
            json.writeArrayFieldStart(View.labels(view));
            for (String s : node.labels()) {
                json.writeString(s);
            }
            json.writeEndArray();
            this.writeEntityProperties(View.properties(view), (Entity)node, json, serializers);
            json.writeEndObject();
            if (view.equals((Object)View.TYPED_JSON)) {
                json.writeEndObject();
            }
        }

        private void writeRelationship(Relationship relationship, JsonGenerator json, SerializerProvider serializers, View view) throws IOException {
            json.writeStartObject();
            if (view.equals((Object)View.TYPED_JSON)) {
                json.writeStringField("$type", CypherTypes.Relationship.name());
                json.writeFieldName("_value");
                json.writeStartObject();
            }
            json.writeStringField(View.elementId(view), relationship.elementId());
            json.writeStringField(View.startNodeElementId(view), relationship.startNodeElementId());
            json.writeStringField(View.endNodeElementId(view), relationship.endNodeElementId());
            json.writeStringField(View.type(view), relationship.type());
            this.writeEntityProperties(View.properties(view), (Entity)relationship, json, serializers);
            json.writeEndObject();
            if (view.equals((Object)View.TYPED_JSON)) {
                json.writeEndObject();
            }
        }
    }

    private static class SummaryCountersSerializer
    extends StdSerializer<SummaryCounters> {
        private static final long serialVersionUID = -4434233555324168878L;

        SummaryCountersSerializer() {
            super(SummaryCounters.class);
        }

        public void serialize(SummaryCounters value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                return;
            }
            gen.writeStartObject();
            gen.writeBooleanField("containsUpdates", value.containsUpdates());
            gen.writeNumberField("nodesCreated", value.nodesCreated());
            gen.writeNumberField("nodesDeleted", value.nodesDeleted());
            gen.writeNumberField("propertiesSet", value.propertiesSet());
            gen.writeNumberField("relationshipsCreated", value.relationshipsCreated());
            gen.writeNumberField("relationshipsDeleted", value.relationshipsDeleted());
            gen.writeNumberField("labelsAdded", value.labelsAdded());
            gen.writeNumberField("labelsRemoved", value.labelsRemoved());
            gen.writeNumberField("indexesAdded", value.indexesAdded());
            gen.writeNumberField("indexesRemoved", value.indexesRemoved());
            gen.writeNumberField("constraintsAdded", value.constraintsAdded());
            gen.writeNumberField("constraintsRemoved", value.constraintsRemoved());
            gen.writeBooleanField("containsSystemUpdates", value.containsSystemUpdates());
            gen.writeNumberField("systemUpdates", value.systemUpdates());
            gen.writeEndObject();
        }
    }

    private static class QueryPlanSerializer
    extends StdSerializer<Plan> {
        private static final long serialVersionUID = -6613007221451028541L;

        public QueryPlanSerializer() {
            super(Plan.class);
        }

        public void serialize(Plan value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("operatorType", value.operatorType());
            gen.writeObjectField("arguments", (Object)value.arguments());
            gen.writeObjectField("identifiers", (Object)value.identifiers());
            gen.writeObjectField("children", (Object)value.children());
            gen.writeEndObject();
        }
    }

    private static final class ProfiledPlanSerializer
    extends StdSerializer<ProfiledPlan> {
        private static final long serialVersionUID = 8533863218949288878L;

        public ProfiledPlanSerializer() {
            super(ProfiledPlan.class);
        }

        public void serialize(ProfiledPlan value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("dbHits", value.dbHits());
            gen.writeNumberField("records", value.records());
            gen.writeBooleanField("hasPageCacheStats", value.hasPageCacheStats());
            gen.writeNumberField("pageCacheHits", value.pageCacheHits());
            gen.writeNumberField("pageCacheMisses", value.pageCacheMisses());
            gen.writeNumberField("pageCacheHitRatio", value.pageCacheHitRatio());
            gen.writeNumberField("time", value.time());
            gen.writeStringField("operatorType", value.operatorType());
            gen.writeObjectField("arguments", (Object)value.arguments());
            gen.writeObjectField("identifiers", (Object)value.identifiers());
            gen.writeObjectField("children", (Object)value.children());
            gen.writeEndObject();
        }
    }

    private static class NotificationSerializer
    extends StdSerializer<Notification> {
        private static final long serialVersionUID = 3823657055285501063L;

        NotificationSerializer() {
            super(Notification.class);
        }

        public void serialize(Notification notification, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("code", notification.code());
            jsonGenerator.writeStringField("description", notification.description());
            jsonGenerator.writeStringField("severity", notification.severity());
            jsonGenerator.writeStringField("title", notification.title());
            jsonGenerator.writeObjectField("position", (Object)notification.position());
            if (notification.category().isPresent()) {
                jsonGenerator.writeStringField("category", ((NotificationCategory)notification.category().get()).toString());
            }
            jsonGenerator.writeEndObject();
        }
    }

    public static interface InputPositionMixIn {
        @JsonProperty
        public int column();

        @JsonProperty
        public int line();

        @JsonProperty
        public int offset();
    }

    @JsonIncludeProperties(value={"code", "message"})
    public static interface Neo4jExceptionMixIn {
        @JsonProperty
        public String code();
    }
}

