/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.logging.InternalLog;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.queryapi.request.TxManagedResultContainer;
import org.neo4j.server.queryapi.response.DriverResultSerializer;
import org.neo4j.server.queryapi.tx.TransactionManager;

abstract class AbstractTxManagingResultWriter
implements MessageBodyWriter<TxManagedResultContainer> {
    private final InternalLog log;
    private final JsonFactory jsonFactory;
    private final TransactionManager transactionManager;

    public AbstractTxManagingResultWriter(InternalLog log, JsonFactory jsonFactory, TransactionManager transactionManager) {
        this.log = log;
        this.jsonFactory = jsonFactory;
        this.transactionManager = transactionManager;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TxManagedResultContainer.class.isAssignableFrom(type);
    }

    public void writeDriverResult(TxManagedResultContainer result, OutputStream outputStream) throws IOException {
        boolean hasFailed = false;
        JsonGenerator jsonGenerator = this.jsonFactory.createGenerator(outputStream);
        DriverResultSerializer resultSerializer = new DriverResultSerializer(jsonGenerator);
        try {
            resultSerializer.writeRecords(result.transaction().retrieveResults());
            if (result.requiresCommit()) {
                Set<Bookmark> bookmarks = result.transaction().commit();
                resultSerializer.finish(result.transaction().resultSummary(), bookmarks, null, null, result.requireSummaryCounters());
            } else {
                result.transaction().extendTimeout();
                resultSerializer.finish(result.transaction().resultSummary(), null, result.transaction().id(), result.transaction().expiresAt(), result.requireSummaryCounters());
            }
        }
        catch (Neo4jException ex) {
            hasFailed = true;
            try {
                resultSerializer.writeError(ex);
            }
            catch (IOException errorWritingException) {
                this.log.warn("An error was thrown whilst attempting to write an error.", (Throwable)errorWritingException);
            }
        }
        catch (IOException ex) {
            hasFailed = true;
            throw new ConnectionException("Failed to write to the connection", ex);
        }
        finally {
            if (!result.transaction().isOpen() || hasFailed) {
                this.transactionManager.removeTransaction(result.transaction().id());
            } else {
                this.transactionManager.releaseTransaction(result.transaction().id());
            }
            jsonGenerator.flush();
        }
    }
}

