/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.diagnostics;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;

public class ServerDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;

    public ServerDiagnosticsOfflineReportProvider() {
        super("logs", new String[0]);
    }

    public void init(FileSystemAbstraction fs, Config config, Set<String> databaseNames) {
        this.fs = fs;
        this.config = config;
    }

    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        Path httpLog;
        if (classifiers.contains("logs") && this.fs.fileExists(httpLog = ((Path)this.config.get(GraphDatabaseSettings.logs_directory)).resolve("http.log"))) {
            return DiagnosticsReportSources.newDiagnosticsRotatingFile((String)"logs/", (FileSystemAbstraction)this.fs, (Path)httpLog);
        }
        return Collections.emptyList();
    }
}

