/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.virtual.MapValue;

public class HttpProfilerStatistics
implements ExecutionPlanDescription.ProfilerStatistics {
    private final long rows;
    private final long dbHits;
    private final long pageCacheHits;
    private final long pageCacheMisses;
    private final double pageCacheRatio;
    private final long time;

    private HttpProfilerStatistics(long rows, long dbHits, long pageCacheHits, long pageCacheMisses, double pageCacheRatio, long time) {
        this.rows = rows;
        this.dbHits = dbHits;
        this.pageCacheHits = pageCacheHits;
        this.pageCacheMisses = pageCacheMisses;
        this.pageCacheRatio = pageCacheRatio;
        this.time = time;
    }

    public static ExecutionPlanDescription.ProfilerStatistics fromMapValue(MapValue mapValue) {
        long dbHits = 0L;
        long rows = 0L;
        long pageCacheHits = 0L;
        long pageCacheMisses = 0L;
        long time = 0L;
        double pageCacheRatio = 0.0;
        if (mapValue.containsKey("dbHits")) {
            dbHits = ((LongValue)mapValue.get("dbHits")).value();
        }
        if (mapValue.containsKey("pageCacheMisses")) {
            pageCacheMisses = ((LongValue)mapValue.get("pageCacheMisses")).value();
        }
        if (mapValue.containsKey("pageCacheHits")) {
            pageCacheHits = ((LongValue)mapValue.get("pageCacheHits")).value();
        }
        if (mapValue.containsKey("pageCacheRatio")) {
            pageCacheRatio = ((DoubleValue)mapValue.get("pageCacheRatio")).value();
        }
        if (mapValue.containsKey("rows")) {
            rows = ((LongValue)mapValue.get("rows")).value();
        }
        if (mapValue.containsKey("time")) {
            time = ((LongValue)mapValue.get("time")).value();
        }
        return new HttpProfilerStatistics(rows, dbHits, pageCacheHits, pageCacheMisses, pageCacheRatio, time);
    }

    public boolean hasRows() {
        return this.rows > 0L;
    }

    public long getRows() {
        return this.rows;
    }

    public boolean hasDbHits() {
        return this.dbHits > 0L;
    }

    public long getDbHits() {
        return this.dbHits;
    }

    public boolean hasPageCacheStats() {
        return this.pageCacheHits > 0L || this.pageCacheMisses > 0L || this.pageCacheRatio > 0.0;
    }

    public long getPageCacheHits() {
        return this.pageCacheHits;
    }

    public long getPageCacheMisses() {
        return this.pageCacheMisses;
    }

    public boolean hasTime() {
        return this.time > 0L;
    }

    public long getTime() {
        return this.time;
    }
}

