/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.neo4j.kernel.internal.Version;
import org.neo4j.server.NeoWebServer;

public class ServerVersionAndEdition {
    private final Map<String, String> serverInfo = new HashMap<String, String>();

    ServerVersionAndEdition(NeoWebServer neoWebServer) {
        this(ServerVersionAndEdition.neoDatabaseVersion(), ServerVersionAndEdition.neoServerEdition(neoWebServer));
    }

    public ServerVersionAndEdition(String version, String edition) {
        this.serverInfo.put("neo4j_version", version);
        this.serverInfo.put("neo4j_edition", edition);
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.serverInfo.forEach(consumer);
    }

    private static String neoDatabaseVersion() {
        return Version.getKernel().getReleaseVersion();
    }

    private static String neoServerEdition(NeoWebServer neoWebServer) {
        return neoWebServer.getDbmsInfo().edition.toString();
    }
}

