/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.cypher.LegacyTransactionService;
import org.neo4j.server.http.cypher.format.input.json.JsonMessageBodyReader;
import org.neo4j.server.http.cypher.format.output.json.JsonMessageBodyWriter;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.Injectable;
import org.neo4j.server.web.WebServer;
import org.neo4j.time.SystemNanoClock;

public class LegacyTransactionModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private final SystemNanoClock clock;

    public LegacyTransactionModule(WebServer webServer, Config config, SystemNanoClock clock) {
        this.webServer = webServer;
        this.config = config;
        this.clock = clock;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(LegacyTransactionModule.jaxRsClasses(), this.mountPoint(), List.of(Injectable.injectable(SystemNanoClock.class, this.clock)));
    }

    private static List<Class<?>> jaxRsClasses() {
        return List.of(LegacyTransactionService.class, JsonMessageBodyReader.class, JsonMessageBodyWriter.class);
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(LegacyTransactionModule.jaxRsClasses(), this.mountPoint());
    }

    private String mountPoint() {
        return ((URI)this.config.get(ServerSettings.rest_api_path)).getPath();
    }
}

