/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.function.Function;
import org.neo4j.server.http.cypher.format.jolt.JoltDelegatingValueSerializer;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltSparseNumberSerializer<T extends Number>
extends StdSerializer<T> {
    private final JsonSerializer<T> delegate;
    private final Sigil sigil;
    private final Function<T, String> converter;

    JoltSparseNumberSerializer(Class<T> t, Sigil sigil, Function<T, String> converter) {
        super(t);
        this.sigil = sigil;
        this.converter = converter;
        this.delegate = new JoltDelegatingValueSerializer<T>(t, sigil, converter);
    }

    public void serialize(T value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        long longValue = ((Number)value).longValue();
        if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
            generator.writeNumber(longValue);
        } else {
            this.delegate.serialize(value, generator, provider);
        }
    }
}

