/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionStateChecker;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.OutputEvent;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.input.json.JsonMessageBodyReader;
import org.neo4j.server.http.cypher.format.output.eventsource.EventSourceSerializer;
import org.neo4j.server.http.cypher.format.output.eventsource.EventSourceWriter;

class LineDelimitedEventSourceJoltSerializer
implements EventSourceSerializer {
    protected final JsonGenerator jsonGenerator;
    protected final TransactionHandle transactionHandle;
    protected final List<Notification> notifications = new ArrayList<Notification>();
    protected final List<FailureEvent> errors = new ArrayList<FailureEvent>();
    protected final OutputStream output;
    private final Map<String, Object> parameters;
    private final EventSourceWriter writer;
    private InputStatement inputStatement;

    LineDelimitedEventSourceJoltSerializer(TransactionHandle transactionHandle, Map<String, Object> parameters, Class<? extends ObjectCodec> classOfCodec, boolean isStrictMode, JsonFactory jsonFactory, OutputStream output) {
        this.parameters = parameters;
        this.transactionHandle = transactionHandle;
        this.output = output;
        this.writer = new EventSourceWriter();
        ObjectCodec codec = LineDelimitedEventSourceJoltSerializer.instantiateCodec(isStrictMode, classOfCodec);
        this.jsonGenerator = LineDelimitedEventSourceJoltSerializer.createGenerator(jsonFactory, codec, output);
    }

    @Override
    public final void handleEvent(OutputEvent event) {
        switch (event.getType()) {
            case STATEMENT_START: {
                StatementStartEvent statementStartEvent = (StatementStartEvent)event;
                InputStatement inputStatement = JsonMessageBodyReader.getInputStatement(this.parameters, statementStartEvent.getStatement());
                this.writeStatementStart(statementStartEvent, inputStatement);
                break;
            }
            case RECORD: {
                this.writeRecord((RecordEvent)event);
                break;
            }
            case STATEMENT_END: {
                StatementEndEvent statementEndEvent = (StatementEndEvent)event;
                this.writeStatementEnd(statementEndEvent);
                break;
            }
            case FAILURE: {
                FailureEvent failureEvent = (FailureEvent)event;
                this.writeFailure(failureEvent);
                break;
            }
            case TRANSACTION_INFO: {
                TransactionInfoEvent transactionInfoEvent = (TransactionInfoEvent)event;
                this.writeErrorWrapper();
                this.writeTransactionInfo(transactionInfoEvent);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported event encountered:" + event.getType());
            }
        }
    }

    private static ObjectCodec instantiateCodec(boolean isStrictMode, Class<? extends ObjectCodec> classOfCodec) {
        try {
            Constructor<? extends ObjectCodec> ctor = classOfCodec.getConstructor(Boolean.TYPE);
            return ctor.newInstance(isStrictMode);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create result mapper", e);
        }
    }

    private static JsonGenerator createGenerator(JsonFactory jsonFactory, ObjectCodec codec, OutputStream output) {
        try {
            return jsonFactory.copy().setRootValueSeparator("").setCodec(codec).createGenerator(output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create JSON generator", e);
        }
    }

    protected void writeStatementStart(StatementStartEvent statementStartEvent, InputStatement inputStatement) {
        this.inputStatement = inputStatement;
        try {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeFieldName("header");
            this.jsonGenerator.writeStartObject();
            List<String> columns = statementStartEvent.getColumns();
            this.writeColumns(columns);
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    protected void writeRecord(RecordEvent recordEvent) {
        try {
            TransactionStateChecker txStateChecker = TransactionStateChecker.create(this.transactionHandle.getContext());
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeFieldName("data");
            try {
                this.writer.write(this.jsonGenerator, recordEvent, txStateChecker);
            }
            finally {
                this.jsonGenerator.writeEndObject();
                this.flush();
            }
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    protected void writeStatementEnd(StatementEndEvent statementEndEvent) {
        try {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeFieldName("summary");
            this.jsonGenerator.writeStartObject();
            if (this.inputStatement.includeStats()) {
                this.writeStats(statementEndEvent.getQueryStatistics());
            }
            if (statementEndEvent.getQueryExecutionType().requestedExecutionPlanDescription()) {
                this.writeRootPlanDescription(statementEndEvent.getExecutionPlanDescription());
            }
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
            statementEndEvent.getNotifications().forEach(this.notifications::add);
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    protected void writeTransactionInfo(TransactionInfoEvent transactionInfoEvent) {
        try {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeFieldName("info");
            this.jsonGenerator.writeStartObject();
            this.writeNotifications();
            if (transactionInfoEvent.getCommitUri() != null) {
                this.jsonGenerator.writeStringField("commit", transactionInfoEvent.getCommitUri().toString());
            }
            if (transactionInfoEvent.getNotification() == TransactionNotificationState.OPEN) {
                this.jsonGenerator.writeObjectFieldStart("transaction");
                if (transactionInfoEvent.getExpirationTimestamp() >= 0L) {
                    String expires = Instant.ofEpochMilli(transactionInfoEvent.getExpirationTimestamp()).atZone(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
                    this.jsonGenerator.writeStringField("expires", expires);
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    protected void writeFailure(FailureEvent failureEvent) {
        this.errors.add(failureEvent);
    }

    protected void writeErrorWrapper() {
        if (this.errors.isEmpty()) {
            return;
        }
        try {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeFieldName("error");
            this.jsonGenerator.writeStartObject();
            this.writeErrors();
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
            this.flush();
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNotifications() {
        if (this.notifications.isEmpty()) {
            return;
        }
        try {
            this.jsonGenerator.writeArrayFieldStart("notifications");
            try {
                for (Notification notification : this.notifications) {
                    this.jsonGenerator.writeStartObject();
                    try {
                        this.jsonGenerator.writeStringField("code", notification.getCode());
                        this.jsonGenerator.writeStringField("severity", notification.getSeverity().toString());
                        this.jsonGenerator.writeStringField("title", notification.getTitle());
                        this.jsonGenerator.writeStringField("description", notification.getDescription());
                        this.writePosition(notification.getPosition());
                    }
                    finally {
                        this.jsonGenerator.writeEndObject();
                    }
                }
            }
            finally {
                this.jsonGenerator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the response stream", e);
        }
    }

    protected void writePosition(InputPosition position) throws IOException {
        if (position == InputPosition.empty) {
            return;
        }
        this.jsonGenerator.writeObjectFieldStart("position");
        try {
            this.jsonGenerator.writeNumberField("offset", position.getOffset());
            this.jsonGenerator.writeNumberField("line", position.getLine());
            this.jsonGenerator.writeNumberField("column", position.getColumn());
        }
        finally {
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeStats(QueryStatistics stats) throws IOException {
        this.jsonGenerator.writeObjectFieldStart("stats");
        try {
            this.jsonGenerator.writeBooleanField("contains_updates", stats.containsUpdates());
            this.jsonGenerator.writeNumberField("nodes_created", stats.getNodesCreated());
            this.jsonGenerator.writeNumberField("nodes_deleted", stats.getNodesDeleted());
            this.jsonGenerator.writeNumberField("properties_set", stats.getPropertiesSet());
            this.jsonGenerator.writeNumberField("relationships_created", stats.getRelationshipsCreated());
            this.jsonGenerator.writeNumberField("relationship_deleted", stats.getRelationshipsDeleted());
            this.jsonGenerator.writeNumberField("labels_added", stats.getLabelsAdded());
            this.jsonGenerator.writeNumberField("labels_removed", stats.getLabelsRemoved());
            this.jsonGenerator.writeNumberField("indexes_added", stats.getIndexesAdded());
            this.jsonGenerator.writeNumberField("indexes_removed", stats.getIndexesRemoved());
            this.jsonGenerator.writeNumberField("constraints_added", stats.getConstraintsAdded());
            this.jsonGenerator.writeNumberField("constraints_removed", stats.getConstraintsRemoved());
            this.jsonGenerator.writeBooleanField("contains_system_updates", stats.containsSystemUpdates());
            this.jsonGenerator.writeNumberField("system_updates", stats.getSystemUpdates());
        }
        finally {
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeRootPlanDescription(ExecutionPlanDescription planDescription) throws IOException {
        this.jsonGenerator.writeObjectFieldStart("plan");
        try {
            this.jsonGenerator.writeObjectFieldStart("root");
            try {
                this.writePlanDescriptionObjectBody(planDescription);
            }
            finally {
                this.jsonGenerator.writeEndObject();
            }
        }
        finally {
            this.jsonGenerator.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlanDescriptionObjectBody(ExecutionPlanDescription planDescription) throws IOException {
        this.jsonGenerator.writeFieldName("operatorType");
        this.jsonGenerator.writeObject((Object)planDescription.getName());
        this.writePlanArgs(planDescription);
        this.writePlanIdentifiers(planDescription);
        List children = planDescription.getChildren();
        this.jsonGenerator.writeArrayFieldStart("children");
        try {
            for (ExecutionPlanDescription child : children) {
                this.jsonGenerator.writeStartObject();
                try {
                    this.writePlanDescriptionObjectBody(child);
                }
                finally {
                    this.jsonGenerator.writeEndObject();
                }
            }
        }
        finally {
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writePlanArgs(ExecutionPlanDescription planDescription) throws IOException {
        for (Map.Entry entry : planDescription.getArguments().entrySet()) {
            String fieldName = (String)entry.getKey();
            Object fieldValue = entry.getValue();
            this.jsonGenerator.writeFieldName(fieldName);
            this.jsonGenerator.writeObject(fieldValue);
        }
    }

    private void writePlanIdentifiers(ExecutionPlanDescription planDescription) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("identifiers");
        for (String id : planDescription.getIdentifiers()) {
            this.jsonGenerator.writeObject((Object)id);
        }
        this.jsonGenerator.writeEndArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrors() {
        try {
            this.jsonGenerator.writeArrayFieldStart("errors");
            try {
                for (FailureEvent error : this.errors) {
                    try {
                        this.jsonGenerator.writeStartObject();
                        this.jsonGenerator.writeObjectField("code", (Object)error.getStatus().code().serialize());
                        this.jsonGenerator.writeObjectField("message", (Object)error.getMessage());
                    }
                    finally {
                        this.jsonGenerator.writeEndObject();
                    }
                }
            }
            finally {
                this.jsonGenerator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the response stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumns(Iterable<String> columns) throws IOException {
        try {
            this.jsonGenerator.writeArrayFieldStart("fields");
            for (String key : columns) {
                this.jsonGenerator.writeString(key);
            }
        }
        finally {
            this.jsonGenerator.writeEndArray();
        }
    }

    private void flush() throws IOException {
        this.jsonGenerator.flush();
        this.output.flush();
        this.output.write("\n".getBytes());
    }
}

