/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.logging.Log;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.OutputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.rest.Neo4jError;

class Invocation {
    private final Log log;
    private final TransactionHandle transactionHandle;
    private final InputEventStream inputEventStream;
    private final boolean finishWithCommit;
    private final URI commitUri;
    private OutputEventStream outputEventStream;
    private boolean hasPrevious;
    private Neo4jError neo4jError;
    private RuntimeException outputError;
    private TransactionNotificationState transactionNotificationState = TransactionNotificationState.NO_TRANSACTION;

    Invocation(Log log, TransactionHandle transactionHandle, URI commitUri, InputEventStream inputEventStream, boolean finishWithCommit) {
        this.log = log;
        this.transactionHandle = transactionHandle;
        this.commitUri = commitUri;
        this.inputEventStream = inputEventStream;
        this.finishWithCommit = finishWithCommit;
    }

    void execute(OutputEventStream outputEventStream) {
        this.outputEventStream = outputEventStream;
        if (!this.executePreStatementsTransactionLogic()) {
            this.sendTransactionStateInformation();
            return;
        }
        this.executeStatements();
        this.executePostStatementsTransactionLogic();
        this.sendTransactionStateInformation();
        if (this.outputError != null) {
            throw this.outputError;
        }
    }

    private boolean executePreStatementsTransactionLogic() {
        try {
            this.transactionHandle.ensureActiveTransaction();
            this.transactionNotificationState = TransactionNotificationState.OPEN;
        }
        catch (AuthorizationViolationException se) {
            this.handleNeo4jError(se.status(), se);
            return false;
        }
        catch (Exception e) {
            if (!this.transactionHandle.hasTransactionContext()) {
                this.log.error("Failed to start transaction", (Throwable)e);
                this.handleNeo4jError((Status)Status.Transaction.TransactionStartFailed, e);
            } else {
                this.log.error("Failed to resume transaction", (Throwable)e);
                this.handleNeo4jError((Status)Status.Transaction.TransactionNotFound, e);
            }
            return false;
        }
        return true;
    }

    private void executePostStatementsTransactionLogic() {
        if (this.outputError != null && this.transactionHandle.isImplicit()) {
            try {
                this.transactionHandle.rollback();
                this.transactionNotificationState = TransactionNotificationState.ROLLED_BACK;
            }
            catch (Exception e) {
                this.log.error("Failed to Rollback of implicit transaction after output error", (Throwable)e);
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        if (this.neo4jError != null && this.neo4jError.status().code().classification().rollbackTransaction()) {
            try {
                this.transactionHandle.rollback();
                this.transactionNotificationState = TransactionNotificationState.ROLLED_BACK;
            }
            catch (Exception e) {
                this.log.error("Failed to roll back transaction.", (Throwable)e);
                this.handleNeo4jError((Status)Status.Transaction.TransactionRollbackFailed, e);
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        if (this.outputError == null && this.finishWithCommit) {
            try {
                this.transactionHandle.commit();
                this.transactionNotificationState = TransactionNotificationState.COMMITTED;
            }
            catch (Exception e) {
                if (e.getCause() instanceof Status.HasStatus) {
                    this.handleNeo4jError(((Status.HasStatus)e.getCause()).status(), e);
                } else {
                    this.log.error("Failed to commit transaction.", (Throwable)e);
                    this.handleNeo4jError((Status)Status.Transaction.TransactionCommitFailed, e);
                }
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        this.transactionHandle.suspendTransaction();
    }

    private void executeStatements() {
        try {
            while (this.outputError == null) {
                Statement statement = this.readStatement();
                if (statement == null) {
                    return;
                }
                this.executeStatement(statement);
            }
        }
        catch (InputFormatException e) {
            this.handleNeo4jError((Status)Status.Request.InvalidFormat, e);
        }
        catch (KernelException | Neo4jException | WriteOperationsNotAllowedException | AuthorizationViolationException e) {
            this.handleNeo4jError(((Status.HasStatus)e).status(), e);
        }
        catch (DeadlockDetectedException e) {
            this.handleNeo4jError((Status)Status.Transaction.DeadlockDetected, e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof Status.HasStatus) {
                this.handleNeo4jError(((Status.HasStatus)cause).status(), cause);
            }
            this.handleNeo4jError((Status)Status.Statement.ExecutionFailed, e);
        }
    }

    private Statement readStatement() {
        try {
            return this.inputEventStream.read();
        }
        catch (ConnectionException e) {
            this.handleOutputError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(Statement statement) throws Exception {
        Result result;
        boolean periodicCommit = this.transactionHandle.isPeriodicCommit(statement.getStatement());
        if (periodicCommit) {
            if (this.hasPrevious || this.readStatement() != null) {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Cannot execute another statement with PERIODIC COMMIT statement in the same transaction", null));
            }
            this.transactionHandle.closeTransactionForPeriodicCommit();
        }
        this.hasPrevious = true;
        try {
            result = this.transactionHandle.executeStatement(statement, periodicCommit);
        }
        finally {
            if (periodicCommit) {
                this.transactionHandle.reopenAfterPeriodicCommit();
            }
        }
        this.writeResult(result, statement);
    }

    private void writeResult(Result result, Statement statement) {
        try {
            this.outputEventStream.writeStatementStart(statement, result.columns());
            result.accept(row -> {
                this.outputEventStream.writeRecord(result.columns(), arg_0 -> ((Result.ResultRow)row).get(arg_0));
                return true;
            });
            this.outputEventStream.writeStatementEnd(result.getQueryExecutionType(), result.getQueryStatistics(), result.getExecutionPlanDescription(), result.getNotifications());
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }

    private void handleOutputError(RuntimeException e) {
        if (this.outputError != null) {
            return;
        }
        this.outputError = e;
        this.log.error("An error has occurred while sending a response", (Throwable)e);
    }

    private void handleNeo4jError(Status status, Throwable cause) {
        this.neo4jError = new Neo4jError(status, cause);
        try {
            this.outputEventStream.writeFailure(status, this.neo4jError.getMessage());
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }

    private void sendTransactionStateInformation() {
        if (this.outputError != null) {
            return;
        }
        try {
            this.outputEventStream.writeTransactionInfo(this.transactionNotificationState, this.commitUri, this.transactionHandle.getExpirationTimestamp());
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }
}

