/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.InvalidArgumentsException;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.RepresentationFormat;

public class DefaultFormat
extends RepresentationFormat {
    private final RepresentationFormat inner;
    private final Collection<MediaType> supported;
    private final MediaType[] requested;

    public DefaultFormat(RepresentationFormat inner, Collection<MediaType> supported, MediaType ... requested) {
        super(MediaType.APPLICATION_JSON_TYPE);
        this.inner = inner;
        this.supported = supported;
        this.requested = requested;
    }

    protected String serializeValue(String type, Object value) {
        return this.inner.serializeValue(type, value);
    }

    protected ListWriter serializeList(String type) {
        return this.inner.serializeList(type);
    }

    protected MappingWriter serializeMapping(String type) {
        return this.inner.serializeMapping(type);
    }

    protected String complete(ListWriter serializer) {
        return this.inner.complete(serializer);
    }

    protected String complete(MappingWriter serializer) {
        return this.inner.complete(serializer);
    }

    public Object readValue(String input) {
        try {
            return this.inner.readValue(input);
        }
        catch (BadInputException e) {
            throw this.newMediaTypeNotSupportedException();
        }
    }

    private MediaTypeNotSupportedException newMediaTypeNotSupportedException() {
        return new MediaTypeNotSupportedException(Response.Status.UNSUPPORTED_MEDIA_TYPE, this.supported, this.requested);
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        Map result;
        try {
            result = this.inner.readMap(input, new String[0]);
        }
        catch (BadInputException e) {
            throw this.newMediaTypeNotSupportedException();
        }
        return DefaultFormat.validateKeys(result, requiredKeys);
    }

    public List<Object> readList(String input) {
        try {
            return this.inner.readList(input);
        }
        catch (BadInputException e) {
            throw this.newMediaTypeNotSupportedException();
        }
    }

    public URI readUri(String input) {
        try {
            return this.inner.readUri(input);
        }
        catch (BadInputException e) {
            throw this.newMediaTypeNotSupportedException();
        }
    }

    public static <T> Map<String, T> validateKeys(Map<String, T> map, String ... requiredKeys) throws BadInputException {
        HashSet<String> missing = null;
        for (String key : requiredKeys) {
            if (map.containsKey(key)) continue;
            if (missing == null) {
                missing = new HashSet<String>();
            }
            missing.add(key);
        }
        if (missing != null) {
            if (missing.size() == 1) {
                throw new InvalidArgumentsException("Missing required key: \"" + (String)missing.iterator().next() + "\"");
            }
            throw new InvalidArgumentsException("Missing required keys: " + missing);
        }
        return map;
    }
}

