/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.server.rest.domain.JsonHelper;

public abstract class AbstractFilter
implements Filter {
    protected static ThrowingConsumer<HttpServletResponse, IOException> error(int code, Object body) {
        return response -> {
            response.setStatus(code);
            response.addHeader("Content-Type", "application/json; charset=UTF-8");
            response.getOutputStream().write(JsonHelper.createJsonFrom(body).getBytes(StandardCharsets.UTF_8));
        };
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    protected HttpServletRequest validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
        return (HttpServletRequest)request;
    }

    protected HttpServletResponse validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
        return (HttpServletResponse)response;
    }
}

