/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.exception;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.exception.UpgradeDisallowedStartupException;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

public class ServerStartupErrors {
    private ServerStartupErrors() {
    }

    public static ServerStartupException translateToServerStartupError(Throwable cause) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
        if (rootCause instanceof UpgradeNotAllowedException) {
            return new UpgradeDisallowedStartupException((UpgradeNotAllowedException)rootCause);
        }
        return new ServerStartupException(String.format("Starting Neo4j failed: %s", cause.getMessage()), cause);
    }
}

