/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.database.LifecycleManagingDatabaseService;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.http.cypher.DisabledTransactionRegistry;
import org.neo4j.server.http.cypher.TransactionRegistry;

public class DisabledNeoServer
implements NeoServer {
    private final DatabaseService db;
    private final Config config;
    private final LifeSupport life = new LifeSupport();

    public DisabledNeoServer(GraphFactory graphFactory, ExternalDependencies dependencies, Config config) {
        this.db = new LifecycleManagingDatabaseService(config, graphFactory, dependencies);
        this.config = config;
        this.life.add((Lifecycle)this.db);
        dependencies.userLogProvider().getLog(this.getClass()).info(AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE);
    }

    @Override
    public void start() {
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    @Override
    public void stop() {
        this.life.stop();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public DatabaseService getDatabaseService() {
        return this.db;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return DisabledTransactionRegistry.INSTANCE;
    }

    @Override
    public URI baseUri() {
        throw new UnsupportedOperationException("Neo4j server is disabled");
    }
}

