/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.HttpConnectionInfo;
import org.neo4j.server.web.JettyHttpConnection;

public class HttpConnectionInfoFactory {
    private HttpConnectionInfoFactory() {
    }

    public static ClientConnectionInfo create(HttpServletRequest request) {
        SocketAddress serverAddress;
        SocketAddress clientAddress;
        String connectionId;
        String protocol = request.getScheme();
        String requestURI = request.getRequestURI();
        JettyHttpConnection connection = JettyHttpConnection.getCurrentJettyHttpConnection();
        if (connection != null) {
            connectionId = connection.id();
            clientAddress = connection.clientAddress();
            serverAddress = connection.serverAddress();
        } else {
            connectionId = null;
            clientAddress = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
            serverAddress = new InetSocketAddress(request.getServerName(), request.getServerPort());
        }
        return new HttpConnectionInfo(connectionId, protocol, clientAddress, serverAddress, requestURI);
    }
}

