/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.transactional.TransactionStateChecker;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;

public class Neo4jJsonCodec
extends ObjectMapper {
    private TransitionalPeriodTransactionMessContainer container;

    public Neo4jJsonCodec(TransitionalPeriodTransactionMessContainer container) {
        this();
        this.container = container;
    }

    public Neo4jJsonCodec() {
        this.getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE});
    }

    public void writeValue(JsonGenerator out, Object value) throws IOException {
        if (value instanceof PropertyContainer) {
            try (TransactionStateChecker txStateChecker = TransactionStateChecker.create(this.container);){
                this.writePropertyContainer(out, (PropertyContainer)value, txStateChecker);
            }
        } else if (value instanceof Path) {
            try (TransactionStateChecker txStateChecker = TransactionStateChecker.create(this.container);){
                this.writePath(out, ((Path)value).iterator(), txStateChecker);
            }
        } else if (value instanceof Iterable) {
            this.writeIterator(out, ((Iterable)value).iterator());
        } else if (value instanceof byte[]) {
            this.writeByteArray(out, (byte[])value);
        } else if (value instanceof Map) {
            this.writeMap(out, (Map)value);
        } else if (value instanceof Geometry) {
            Geometry geom = (Geometry)value;
            List coordinates = geom instanceof Point ? ((Point)geom).getCoordinate() : geom.getCoordinates();
            this.writeMap(out, MapUtil.genericMap(new LinkedHashMap(), (Object[])new Object[]{"type", geom.getGeometryType(), "coordinates", coordinates, "crs", geom.getCRS()}));
        } else if (value instanceof Coordinate) {
            Coordinate coordinate = (Coordinate)value;
            this.writeIterator(out, coordinate.getCoordinate().iterator());
        } else if (value instanceof CRS) {
            CRS crs = (CRS)value;
            this.writeMap(out, MapUtil.genericMap(new LinkedHashMap(), (Object[])new Object[]{"srid", crs.getCode(), "name", crs.getType(), "type", "link", "properties", MapUtil.genericMap(new LinkedHashMap(), (Object[])new Object[]{"href", crs.getHref() + "ogcwkt/", "type", "ogcwkt"})}));
        } else if (value instanceof Temporal || value instanceof TemporalAmount) {
            super.writeValue(out, (Object)value.toString());
        } else if (value != null && value.getClass().isArray() && this.supportedArrayType(value.getClass().getComponentType())) {
            this.writeReflectiveArray(out, value);
        } else {
            super.writeValue(out, value);
        }
    }

    private boolean supportedArrayType(Class<?> valueClass) {
        return Geometry.class.isAssignableFrom(valueClass) || CRS.class.isAssignableFrom(valueClass) || Temporal.class.isAssignableFrom(valueClass) || TemporalAmount.class.isAssignableFrom(valueClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReflectiveArray(JsonGenerator out, Object array) throws IOException {
        out.writeStartArray();
        try {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.writeValue(out, Array.get(array, i));
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMap(JsonGenerator out, Map value) throws IOException {
        out.writeStartObject();
        try {
            Set set = value.entrySet();
            for (Map.Entry e : set) {
                Object key = e.getKey();
                out.writeFieldName(key == null ? "null" : key.toString());
                this.writeValue(out, e.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    private void writeIterator(JsonGenerator out, Iterator value) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writeValue(out, value.next());
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePath(JsonGenerator out, Iterator<PropertyContainer> value, TransactionStateChecker txStateChecker) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writePropertyContainer(out, value.next(), txStateChecker);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private void writePropertyContainer(JsonGenerator out, PropertyContainer value, TransactionStateChecker txStateChecker) throws IOException {
        if (value instanceof Node) {
            this.writeNodeOrRelationship(out, value, txStateChecker.isNodeDeletedInCurrentTx(((Node)value).getId()));
        } else if (value instanceof Relationship) {
            this.writeNodeOrRelationship(out, value, txStateChecker.isRelationshipDeletedInCurrentTx(((Relationship)value).getId()));
        } else {
            throw new IllegalArgumentException("Expected a Node or Relationship, but got a " + value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeOrRelationship(JsonGenerator out, PropertyContainer entity, boolean isDeleted) throws IOException {
        out.writeStartObject();
        try {
            if (!isDeleted) {
                for (Map.Entry property : entity.getAllProperties().entrySet()) {
                    out.writeObjectField((String)property.getKey(), property.getValue());
                }
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteArray(JsonGenerator out, byte[] bytes) throws IOException {
        out.writeStartArray();
        try {
            for (byte b : bytes) {
                out.writeNumber((int)b);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    void writeMeta(JsonGenerator out, Object value) throws IOException {
        if (value instanceof Node) {
            Node node = (Node)value;
            try (TransactionStateChecker stateChecker = TransactionStateChecker.create(this.container);){
                this.writeNodeOrRelationshipMeta(out, node.getId(), Neo4jJsonMetaType.NODE, stateChecker.isNodeDeletedInCurrentTx(node.getId()));
            }
        } else if (value instanceof Relationship) {
            Relationship relationship = (Relationship)value;
            try (TransactionStateChecker transactionStateChecker = TransactionStateChecker.create(this.container);){
                this.writeNodeOrRelationshipMeta(out, relationship.getId(), Neo4jJsonMetaType.RELATIONSHIP, transactionStateChecker.isRelationshipDeletedInCurrentTx(relationship.getId()));
            }
        } else if (value instanceof Path) {
            this.writeMetaPath(out, (Path)value);
        } else if (value instanceof Iterable) {
            for (Object v : (Iterable)value) {
                this.writeMeta(out, v);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                this.writeMeta(out, map.get(key));
            }
        } else if (value instanceof Geometry) {
            this.writeObjectMeta(out, this.parseGeometryType((Geometry)value));
        } else if (value instanceof Temporal) {
            this.writeObjectMeta(out, this.parseTemporalType((Temporal)value));
        } else if (value instanceof TemporalAmount) {
            this.writeObjectMeta(out, Neo4jJsonMetaType.DURATION);
        } else {
            out.writeNull();
        }
    }

    private Neo4jJsonMetaType parseGeometryType(Geometry value) throws IOException {
        Neo4jJsonMetaType type = null;
        if (value instanceof Point) {
            type = Neo4jJsonMetaType.POINT;
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Unsupported Geometry type: type=%s, value=%s", value.getClass().getSimpleName(), value));
        }
        return type;
    }

    private Neo4jJsonMetaType parseTemporalType(Temporal value) {
        Neo4jJsonMetaType type = null;
        if (value instanceof ZonedDateTime) {
            type = Neo4jJsonMetaType.DATE_TIME;
        } else if (value instanceof LocalDate) {
            type = Neo4jJsonMetaType.DATE;
        } else if (value instanceof OffsetTime) {
            type = Neo4jJsonMetaType.TIME;
        } else if (value instanceof LocalDateTime) {
            type = Neo4jJsonMetaType.LOCAL_DATE_TIME;
        } else if (value instanceof LocalTime) {
            type = Neo4jJsonMetaType.LOCAL_TIME;
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Unsupported Temporal type: type=%s, value=%s", value.getClass().getSimpleName(), value));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetaPath(JsonGenerator out, Path value) throws IOException {
        out.writeStartArray();
        try {
            for (PropertyContainer element : value) {
                this.writeMeta(out, element);
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    private void writeObjectMeta(JsonGenerator out, Neo4jJsonMetaType type) throws IOException {
        Objects.requireNonNull(type, "The meta type cannot be null for known types.");
        out.writeStartObject();
        try {
            out.writeStringField("type", type.code());
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeOrRelationshipMeta(JsonGenerator out, long id, Neo4jJsonMetaType type, boolean isDeleted) throws IOException {
        Objects.requireNonNull(type, "The meta type could not be null for node or relationship.");
        out.writeStartObject();
        try {
            out.writeNumberField("id", id);
            out.writeStringField("type", type.code());
            out.writeBooleanField("deleted", isDeleted);
        }
        finally {
            out.writeEndObject();
        }
    }

    private static enum Neo4jJsonMetaType {
        NODE("node"),
        RELATIONSHIP("relationship"),
        DATE_TIME("datetime"),
        TIME("time"),
        LOCAL_DATE_TIME("localdatetime"),
        DATE("date"),
        LOCAL_TIME("localtime"),
        DURATION("duration"),
        POINT("point");

        private final String code;

        private Neo4jJsonMetaType(String code) {
            this.code = code;
        }

        String code() {
            return this.code;
        }
    }
}

