/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

public class JettyThreadCalculator {
    public static final int MAX_THREADS = 44738;
    private int acceptors;
    private int selectors;
    private int minThreads;
    private int maxThreads;
    private int maxCapacity;

    public JettyThreadCalculator(int jettyMaxThreads) {
        if (jettyMaxThreads < 1) {
            throw new IllegalArgumentException("Max threads can't be less than 1");
        }
        if (jettyMaxThreads > 44738) {
            throw new IllegalArgumentException(String.format("Max threads can't exceed %d", 44738));
        }
        int transactionThreads = jettyMaxThreads / 5;
        this.acceptors = Math.max(1, transactionThreads / 3);
        this.selectors = Math.max(1, transactionThreads - this.acceptors);
        if (jettyMaxThreads < 4) {
            this.acceptors = 1;
            this.selectors = 1;
        } else if (jettyMaxThreads == 4) {
            this.acceptors = 1;
            this.selectors = 2;
        } else if (jettyMaxThreads <= 8) {
            this.acceptors = 2;
            this.selectors = 3;
        } else if (jettyMaxThreads <= 16) {
            transactionThreads = jettyMaxThreads / 4;
            this.acceptors = Math.max(2, transactionThreads / 3);
            this.selectors = Math.max(3, transactionThreads - this.acceptors);
        }
        this.minThreads = Math.max(2, transactionThreads) + (this.acceptors + this.selectors) * 2;
        this.maxThreads = Math.max(jettyMaxThreads - this.selectors - this.acceptors, 8) + (this.acceptors + this.selectors) * 2;
        this.maxCapacity = (this.maxThreads - (this.selectors + this.acceptors) * 2) * 1000 * 60;
    }

    public int getAcceptors() {
        return this.acceptors;
    }

    public int getSelectors() {
        return this.selectors;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

