/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/resource")
public class ResourcesService {
    static final String JAVASCRIPT_BODY;

    public ResourcesService(@Context UriInfo uriInfo) {
    }

    @GET
    @Path(value="htmlbrowse.js")
    public String getHtmlBrowseJavaScript() {
        return JAVASCRIPT_BODY;
    }

    private static String readFileAsString(String file) {
        try {
            return ResourcesService.readAsString(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readResourceAsString(String resource) {
        return ResourcesService.readAsString(ClassLoader.getSystemResourceAsStream(resource));
    }

    private static String readAsString(InputStream input) {
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int read;
            reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            do {
                if ((read = ((Reader)reader).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return out.toString();
    }

    static {
        String body = null;
        try {
            body = ResourcesService.readResourceAsString("htmlbrowse.js");
        }
        catch (Exception e) {
            body = ResourcesService.readFileAsString("src/main/resources/htmlbrowse.js");
        }
        JAVASCRIPT_BODY = body;
    }
}

