/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.exception;

import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedException;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.exception.UpgradeDisallowedStartupException;

public class ServerStartupErrors {
    private ServerStartupErrors() {
    }

    public static ServerStartupException translateToServerStartupError(Throwable cause) {
        Throwable rootCause = Exceptions.rootCause((Throwable)cause);
        if (rootCause instanceof UpgradeNotAllowedException) {
            return new UpgradeDisallowedStartupException((UpgradeNotAllowedException)rootCause);
        }
        return new ServerStartupException(String.format("Starting Neo4j failed: %s", cause.getMessage()), cause);
    }
}

