/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class MediaTypeNotSupportedException
extends WebApplicationException {
    private static final long serialVersionUID = 5159216782240337940L;

    public MediaTypeNotSupportedException(Response.Status status, Collection<MediaType> supported, MediaType ... requested) {
        super(MediaTypeNotSupportedException.createResponse(status, MediaTypeNotSupportedException.message(supported, requested)));
    }

    private static Response createResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).entity((Object)message).build();
    }

    private static String message(Collection<MediaType> supported, MediaType[] requested) {
        StringBuilder message = new StringBuilder("No matching representation format found.\n");
        if (requested.length == 0) {
            message.append("No requested representation format supplied.");
        } else if (requested.length == 1) {
            message.append("Request format: ").append(requested[0]).append("\n");
        } else {
            message.append("Requested formats:\n");
            for (int i = 0; i < requested.length; ++i) {
                message.append(" ").append(i).append(". ");
                message.append(requested[i]).append("\n");
            }
        }
        message.append("Supported representation formats:");
        if (supported.isEmpty()) {
            message.append(" none");
        } else {
            for (MediaType type : supported) {
                message.append("\n * ").append(type);
            }
        }
        return message.toString();
    }
}

