/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;

@Provider
public final class OutputFormatProvider
extends InjectableProvider<OutputFormat> {
    private final RepresentationFormatRepository repository;

    public OutputFormatProvider(RepresentationFormatRepository repository) {
        super(OutputFormat.class);
        this.repository = repository;
    }

    public OutputFormat getValue(HttpContext context) {
        try {
            HttpRequestContext request = context.getRequest();
            return this.repository.outputFormat(request.getAcceptableMediaTypes(), request.getBaseUri(), (MultivaluedMap<String, String>)request.getRequestHeaders());
        }
        catch (MediaTypeNotSupportedException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)e.getMessage()).build());
        }
    }
}

