/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.server.NeoServer;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.management.AdvertisableService;

@Path(value="server/version")
public class VersionAndEditionService
implements AdvertisableService {
    private NeoServer neoServer;
    public static final String SERVER_PATH = "server/version";

    public VersionAndEditionService(@Context NeoServer neoServer) {
        this.neoServer = neoServer;
    }

    @Override
    public String getName() {
        return "version";
    }

    @Override
    public String getServerPath() {
        return SERVER_PATH;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getVersionAndEditionData() {
        return Response.ok((Object)JsonHelper.createJsonFrom(MapUtil.map((Object[])new Object[]{"version", this.neoDatabaseVersion(this.neoServer), "edition", this.neoServerEdition(this.neoServer)})), (String)"application/json").build();
    }

    private String neoDatabaseVersion(NeoServer neoServer) {
        return ((KernelData)neoServer.getDatabase().getGraph().getDependencyResolver().resolveDependency(KernelData.class)).version().getReleaseVersion();
    }

    private String neoServerEdition(NeoServer neoServer) {
        String serverClassName = neoServer.getClass().getName().toLowerCase();
        if (serverClassName.contains("enterpriseneoserver") || serverClassName.contains("commercialneoserver")) {
            return "enterprise";
        }
        if (serverClassName.contains("communityneoserver")) {
            return "community";
        }
        throw new IllegalStateException("The Neo Server running is of unknown type. Valid types are Community and Enterprise.");
    }
}

