/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.server.rest.repr.ExtensionPointRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.RepresentationType;

public final class ServerExtensionRepresentation
extends MappingRepresentation {
    private final Map<String, EntityExtensionRepresentation> extended = new HashMap<String, EntityExtensionRepresentation>();

    public ServerExtensionRepresentation(String name, List<ExtensionPointRepresentation> methods) {
        super(RepresentationType.SERVER_PLUGIN_DESCRIPTION);
        for (ExtensionPointRepresentation extension : methods) {
            EntityExtensionRepresentation entity = this.extended.computeIfAbsent(extension.getExtendedEntity(), k -> new EntityExtensionRepresentation());
            entity.add(extension);
        }
    }

    protected void serialize(MappingSerializer serializer) {
        for (Map.Entry<String, EntityExtensionRepresentation> entity : this.extended.entrySet()) {
            serializer.putMapping(entity.getKey(), (MappingRepresentation)entity.getValue());
        }
    }

    private static class EntityExtensionRepresentation
    extends MappingRepresentation {
        private final List<ExtensionPointRepresentation> extensions = new ArrayList<ExtensionPointRepresentation>();

        EntityExtensionRepresentation() {
            super("entity-extensions");
        }

        void add(ExtensionPointRepresentation extension) {
            this.extensions.add(extension);
        }

        protected void serialize(MappingSerializer serializer) {
            for (ExtensionPointRepresentation extension : this.extensions) {
                serializer.putMapping(extension.getName(), (MappingRepresentation)extension);
            }
        }
    }
}

