/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting;

import java.util.Collections;
import java.util.Map;
import org.neo4j.server.scripting.NoSuchScriptLanguageException;
import org.neo4j.server.scripting.ScriptExecutor;

public class ScriptExecutorFactoryRepository {
    private final Map<String, ScriptExecutor.Factory> languages;

    public ScriptExecutorFactoryRepository(Map<String, ScriptExecutor.Factory> languages) {
        this.languages = Collections.unmodifiableMap(languages);
    }

    public ScriptExecutor.Factory getFactory(String language) {
        if (this.languages.containsKey(language)) {
            return this.languages.get(language);
        }
        throw new NoSuchScriptLanguageException("Unknown scripting language '" + language + "'.");
    }
}

