/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonHelper;

public abstract class AuthorizationFilter
implements Filter {
    protected static ThrowingConsumer<HttpServletResponse, IOException> error(int code, Object body) {
        return response -> {
            response.setStatus(code);
            response.addHeader("Content-Type", "application/json; charset=UTF-8");
            response.getOutputStream().write(JsonHelper.createJsonFrom(body).getBytes(StandardCharsets.UTF_8));
        };
    }

    protected static ThrowingConsumer<HttpServletResponse, IOException> unauthorizedAccess(String message) {
        return AuthorizationFilter.error(403, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.Forbidden.code().serialize(), "message", String.format("Unauthorized access violation: %s.", message)}))}));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected void validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
    }

    protected void validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
    }
}

