/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.web.WebServer;

public class DBMSModule
implements ServerModule {
    private static final String ROOT_PATH = "/";
    private final WebServer webServer;
    private final Config config;

    public DBMSModule(WebServer webServer, Config config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(this.getClassNames(), ROOT_PATH, null);
    }

    private List<String> getClassNames() {
        ArrayList<String> toReturn = new ArrayList<String>(2);
        toReturn.add(DiscoveryService.class.getName());
        if (((Boolean)this.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            toReturn.add(UserService.class.getName());
        }
        return toReturn;
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), ROOT_PATH);
    }
}

