/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;

public class CypherStatisticsRepresentation
extends MappingRepresentation {
    private final QueryStatistics stats;

    public CypherStatisticsRepresentation(QueryStatistics stats) {
        super("stats");
        this.stats = stats;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putBoolean("contains_updates", this.stats.containsUpdates());
        serializer.putNumber("nodes_created", (Number)this.stats.getNodesCreated());
        serializer.putNumber("nodes_deleted", (Number)this.stats.getNodesDeleted());
        serializer.putNumber("properties_set", (Number)this.stats.getPropertiesSet());
        serializer.putNumber("relationships_created", (Number)this.stats.getRelationshipsCreated());
        serializer.putNumber("relationship_deleted", (Number)this.stats.getRelationshipsDeleted());
        serializer.putNumber("labels_added", (Number)this.stats.getLabelsAdded());
        serializer.putNumber("labels_removed", (Number)this.stats.getLabelsRemoved());
        serializer.putNumber("indexes_added", (Number)this.stats.getIndexesAdded());
        serializer.putNumber("indexes_removed", (Number)this.stats.getIndexesRemoved());
        serializer.putNumber("constraints_added", (Number)this.stats.getConstraintsAdded());
        serializer.putNumber("constraints_removed", (Number)this.stats.getConstraintsRemoved());
    }
}

