/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.server.helpers.PropertyTypeDispatcher;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class PropertiesRepresentation
extends MappingRepresentation {
    private final PropertyContainer entity;

    public PropertiesRepresentation(PropertyContainer entity) {
        super(RepresentationType.PROPERTIES);
        this.entity = entity;
    }

    public boolean isEmpty() {
        return !this.entity.getPropertyKeys().iterator().hasNext();
    }

    protected void serialize(MappingSerializer serializer) {
        this.serialize(serializer.writer);
    }

    void serialize(MappingWriter writer) {
        PropertyTypeDispatcher.consumeProperties((PropertyTypeDispatcher)new Consumer(writer), (PropertyContainer)this.entity);
    }

    public static Representation value(Object property) {
        return ValueRepresentation.property((Object)property);
    }

    private static class Consumer
    extends PropertyTypeDispatcher<String, Void> {
        private final MappingWriter writer;

        Consumer(MappingWriter serializer) {
            this.writer = serializer;
        }

        protected Void dispatchBooleanProperty(boolean property, String param) {
            this.writer.writeBoolean(param, property);
            return null;
        }

        protected Void dispatchByteProperty(byte property, String param) {
            this.writer.writeInteger(RepresentationType.BYTE, param, (long)property);
            return null;
        }

        protected Void dispatchCharacterProperty(char property, String param) {
            this.writer.writeInteger(RepresentationType.CHAR, param, (long)property);
            return null;
        }

        protected Void dispatchDoubleProperty(double property, String param) {
            this.writer.writeFloatingPointNumber(RepresentationType.DOUBLE, param, property);
            return null;
        }

        protected Void dispatchFloatProperty(float property, String param) {
            this.writer.writeFloatingPointNumber(RepresentationType.FLOAT, param, (double)property);
            return null;
        }

        protected Void dispatchIntegerProperty(int property, String param) {
            this.writer.writeInteger(RepresentationType.INTEGER, param, (long)property);
            return null;
        }

        protected Void dispatchLongProperty(long property, String param) {
            this.writer.writeInteger(RepresentationType.LONG, param, property);
            return null;
        }

        protected Void dispatchShortProperty(short property, String param) {
            this.writer.writeInteger(RepresentationType.SHORT, param, (long)property);
            return null;
        }

        protected Void dispatchStringProperty(String property, String param) {
            this.writer.writeString(param, property);
            return null;
        }

        protected Void dispatchStringArrayProperty(String[] property, String param) {
            ListWriter list = this.writer.newList(RepresentationType.STRING, param);
            for (String s : property) {
                list.writeString(s);
            }
            list.done();
            return null;
        }

        protected Void dispatchByteArrayProperty(PropertyTypeDispatcher.PropertyArray<byte[], Byte> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.BYTE, param);
            for (Byte b : array) {
                list.writeInteger(RepresentationType.BYTE, (long)b.byteValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchShortArrayProperty(PropertyTypeDispatcher.PropertyArray<short[], Short> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.SHORT, param);
            for (Short s : array) {
                list.writeInteger(RepresentationType.SHORT, (long)s.shortValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchCharacterArrayProperty(PropertyTypeDispatcher.PropertyArray<char[], Character> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.CHAR, param);
            for (Character c : array) {
                list.writeInteger(RepresentationType.CHAR, (long)c.charValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchIntegerArrayProperty(PropertyTypeDispatcher.PropertyArray<int[], Integer> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.INTEGER, param);
            for (Integer i : array) {
                list.writeInteger(RepresentationType.INTEGER, (long)i.intValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchLongArrayProperty(PropertyTypeDispatcher.PropertyArray<long[], Long> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.LONG, param);
            for (Long j : array) {
                list.writeInteger(RepresentationType.LONG, j.longValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchFloatArrayProperty(PropertyTypeDispatcher.PropertyArray<float[], Float> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.FLOAT, param);
            for (Float f : array) {
                list.writeFloatingPointNumber(RepresentationType.FLOAT, (double)f.floatValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchDoubleArrayProperty(PropertyTypeDispatcher.PropertyArray<double[], Double> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.DOUBLE, param);
            for (Double d : array) {
                list.writeFloatingPointNumber(RepresentationType.DOUBLE, d.doubleValue());
            }
            list.done();
            return null;
        }

        protected Void dispatchBooleanArrayProperty(PropertyTypeDispatcher.PropertyArray<boolean[], Boolean> array, String param) {
            ListWriter list = this.writer.newList(RepresentationType.BOOLEAN, param);
            for (Boolean z : array) {
                list.writeBoolean(z.booleanValue());
            }
            list.done();
            return null;
        }
    }
}

