/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.time.Clock;
import java.util.UUID;
import org.neo4j.server.rest.paging.LeaseAlreadyExpiredException;
import org.neo4j.server.rest.paging.PagedTraverser;

public class Lease {
    private long startTime;
    public final PagedTraverser leasedTraverser;
    private final String id;
    private long leasePeriod;
    private final Clock clock;

    Lease(PagedTraverser leasedTraverser, long leasePeriodInSeconds, Clock clock) throws LeaseAlreadyExpiredException {
        if (leasePeriodInSeconds < 0L) {
            throw new LeaseAlreadyExpiredException(String.format("Negative lease periods [%d] are not permitted", leasePeriodInSeconds));
        }
        this.clock = clock;
        this.leasedTraverser = leasedTraverser;
        this.startTime = clock.millis();
        this.leasePeriod = leasePeriodInSeconds * 1000L;
        this.id = this.toHexOnly(UUID.randomUUID());
    }

    public String getId() {
        return this.id;
    }

    private String toHexOnly(UUID uuid) {
        return uuid.toString().replaceAll("-", "");
    }

    public PagedTraverser getLeasedItemAndRenewLease() {
        this.renew();
        return this.leasedTraverser;
    }

    public void renew() {
        if (!this.expired()) {
            this.startTime = this.clock.millis();
        }
    }

    public boolean expired() {
        return this.startTime + this.leasePeriod < this.clock.millis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getPeriod() {
        return this.leasePeriod;
    }
}

