/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;

public class ServerCommandLineArgs {
    public static final String CONFIG_DIR_ARG = "config-dir";
    public static final String HOME_DIR_ARG = "home-dir";
    public static final String VERSION_ARG = "version";
    private final Args args;
    private final Pair<String, String>[] configOverrides;

    private ServerCommandLineArgs(Args args, Pair<String, String>[] configOverrides) {
        this.args = args;
        this.configOverrides = configOverrides;
    }

    public static ServerCommandLineArgs parse(String[] argv) {
        Args args = Args.withFlags((String[])new String[]{VERSION_ARG}).parse(argv);
        return new ServerCommandLineArgs(args, ServerCommandLineArgs.parseConfigOverrides(args));
    }

    public Pair<String, String>[] configOverrides() {
        return this.configOverrides;
    }

    public Optional<File> configFile() {
        return Optional.ofNullable(this.args.get(CONFIG_DIR_ARG)).map(dirPath -> new File((String)dirPath, "neo4j.conf"));
    }

    private static Pair<String, String>[] parseConfigOverrides(Args arguments) {
        Collection options = arguments.interpretOptions("c", Converters.optional(), s -> {
            if (s.contains("=")) {
                String[] keyVal = s.split("=", 2);
                return Pair.pair((Object)keyVal[0], (Object)keyVal[1]);
            }
            return Pair.pair((Object)s, (Object)"true");
        }, new Validator[0]);
        return options.toArray(new Pair[options.size()]);
    }

    public File homeDir() {
        if (this.args.get(HOME_DIR_ARG) == null) {
            return null;
        }
        return new File(this.args.get(HOME_DIR_ARG));
    }

    public boolean version() {
        return this.args.getBoolean(VERSION_ARG, Boolean.valueOf(false));
    }
}

