/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.plugins.BooleanTypeCaster;
import org.neo4j.server.plugins.ByteTypeCaster;
import org.neo4j.server.plugins.CharacterTypeCaster;
import org.neo4j.server.plugins.DataExtractor;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.DoubleTypeCaster;
import org.neo4j.server.plugins.FloatTypeCaster;
import org.neo4j.server.plugins.IntegerTypeCaster;
import org.neo4j.server.plugins.ListParameterExtractor;
import org.neo4j.server.plugins.LongTypeCaster;
import org.neo4j.server.plugins.MapTypeCaster;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.NodeTypeCaster;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.ParameterExtractor;
import org.neo4j.server.plugins.PluginMethod;
import org.neo4j.server.plugins.PluginPoint;
import org.neo4j.server.plugins.PluginPointFactory;
import org.neo4j.server.plugins.RelationshipTypeCaster;
import org.neo4j.server.plugins.RelationshipTypeTypeCaster;
import org.neo4j.server.plugins.ResultConverter;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.ShortTypeCaster;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.plugins.SourceExtractor;
import org.neo4j.server.plugins.StringTypeCaster;
import org.neo4j.server.plugins.TypeCaster;
import org.neo4j.server.plugins.URLTypeCaster;
import org.neo4j.server.plugins.UriTypeCaster;

class PluginPointFactoryImpl
implements PluginPointFactory {
    private static final Map<Class<?>, TypeCaster> TYPES = new HashMap();

    PluginPointFactoryImpl() {
    }

    public PluginPoint createFrom(ServerPlugin plugin, Method method, Class<?> discovery) {
        ResultConverter result = ResultConverter.get(method.getGenericReturnType());
        Type[] types = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        SourceExtractor sourceExtractor = null;
        DataExtractor[] extractors = new DataExtractor[types.length];
        for (int i = 0; i < types.length; ++i) {
            Description description = null;
            Parameter param = null;
            Source source = null;
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof Description) {
                    description = (Description)annotation;
                    continue;
                }
                if (annotation instanceof Parameter) {
                    param = (Parameter)annotation;
                    continue;
                }
                if (!(annotation instanceof Source)) continue;
                source = (Source)annotation;
            }
            if (param != null && source != null) {
                throw new IllegalStateException(String.format("Method parameter %d of %s cannot be retrieved as both Parameter and Source", i, method));
            }
            if (source != null) {
                if (types[i] != discovery) {
                    throw new IllegalStateException("Source parameter type (" + types[i] + ") must equal the discovery type (" + discovery.getName() + ").");
                }
                if (sourceExtractor != null) {
                    throw new IllegalStateException("Server Extension methods may have at most one Source parameter.");
                }
                sourceExtractor = new SourceExtractor(source, description);
                extractors[i] = sourceExtractor;
                continue;
            }
            if (param != null) {
                extractors[i] = PluginPointFactoryImpl.parameterExtractor(types[i], param, description);
                continue;
            }
            throw new IllegalStateException("Parameters of Server Extension methods must be annotated as either Source or Parameter.");
        }
        return new PluginMethod(PluginPointFactoryImpl.nameOf(method), discovery, plugin, result, method, extractors, method.getAnnotation(Description.class));
    }

    private static ParameterExtractor parameterExtractor(Type type, Parameter parameter, Description description) {
        TypeCaster caster;
        GenericArrayType array;
        Type component;
        if (type instanceof ParameterizedType) {
            TypeCaster caster2;
            ParameterizedType paramType = (ParameterizedType)type;
            Class raw = (Class)paramType.getRawType();
            Type componentType = paramType.getActualTypeArguments()[0];
            Class component2 = null;
            if (componentType instanceof Class) {
                component2 = (Class)componentType;
            }
            if (Set.class == raw) {
                TypeCaster caster3 = TYPES.get(component2);
                if (caster3 != null) {
                    return new ListParameterExtractor(caster3, component2, parameter, description){

                        @Override
                        Object convert(Object[] result) {
                            return new HashSet<Object>(Arrays.asList(result));
                        }
                    };
                }
            } else if ((List.class == raw || Collection.class == raw || Iterable.class == raw) && (caster2 = TYPES.get(component2)) != null) {
                return new ListParameterExtractor(caster2, component2, parameter, description){

                    @Override
                    Object convert(Object[] result) {
                        return Arrays.asList(result);
                    }
                };
            }
        } else if (type instanceof Class) {
            Class raw = (Class)type;
            if (raw.isArray()) {
                TypeCaster caster4 = TYPES.get(raw.getComponentType());
                if (caster4 != null) {
                    return new ListParameterExtractor(caster4, (Class)raw.getComponentType(), parameter, description){

                        @Override
                        Object convert(Object[] result) {
                            return result;
                        }
                    };
                }
            } else {
                TypeCaster caster5 = TYPES.get(raw);
                if (caster5 != null) {
                    return new ParameterExtractor(caster5, raw, parameter, description);
                }
            }
        } else if (type instanceof GenericArrayType && (component = (array = (GenericArrayType)type).getGenericComponentType()) instanceof Class && (caster = TYPES.get(component)) != null) {
            return new ListParameterExtractor(caster, (Class)component, parameter, description){

                @Override
                Object convert(Object[] result) {
                    return result;
                }
            };
        }
        throw new IllegalStateException("Unsupported parameter type: " + type);
    }

    private static void put(Map<Class<?>, TypeCaster> types, TypeCaster caster, Class<?> ... keys) {
        for (Class<?> key : keys) {
            types.put(key, caster);
        }
    }

    private static String nameOf(Method method) {
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            return name.value();
        }
        return method.getName();
    }

    static {
        PluginPointFactoryImpl.put(TYPES, new StringTypeCaster(), String.class);
        PluginPointFactoryImpl.put(TYPES, new ByteTypeCaster(), Byte.TYPE, Byte.class);
        PluginPointFactoryImpl.put(TYPES, new ShortTypeCaster(), Short.TYPE, Short.class);
        PluginPointFactoryImpl.put(TYPES, new IntegerTypeCaster(), Integer.TYPE, Integer.class);
        PluginPointFactoryImpl.put(TYPES, new LongTypeCaster(), Long.TYPE, Long.class);
        PluginPointFactoryImpl.put(TYPES, new CharacterTypeCaster(), Character.TYPE, Character.class);
        PluginPointFactoryImpl.put(TYPES, new BooleanTypeCaster(), Boolean.TYPE, Boolean.class);
        PluginPointFactoryImpl.put(TYPES, new FloatTypeCaster(), Float.TYPE, Float.class);
        PluginPointFactoryImpl.put(TYPES, new DoubleTypeCaster(), Double.TYPE, Double.class);
        PluginPointFactoryImpl.put(TYPES, new MapTypeCaster(), Map.class);
        PluginPointFactoryImpl.put(TYPES, new NodeTypeCaster(), Node.class);
        PluginPointFactoryImpl.put(TYPES, new RelationshipTypeCaster(), Relationship.class);
        PluginPointFactoryImpl.put(TYPES, new RelationshipTypeTypeCaster(), RelationshipType.class);
        PluginPointFactoryImpl.put(TYPES, new UriTypeCaster(), URI.class);
        PluginPointFactoryImpl.put(TYPES, new URLTypeCaster(), URL.class);
    }
}

