/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AuthorizedRequestWrapper
extends HttpServletRequestWrapper {
    private final String authType;
    private final DelegatingPrinciple principle;

    public AuthorizedRequestWrapper(String authType, String username, HttpServletRequest request) {
        super(request);
        this.authType = authType;
        this.principle = new DelegatingPrinciple(username);
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getUserPrincipal() {
        return this.principle;
    }

    public boolean isUserInRole(String role) {
        return true;
    }

    public String toString() {
        return "AuthorizedRequestWrapper{authType='" + this.authType + '\'' + ", principle=" + this.principle + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AuthorizedRequestWrapper that = (AuthorizedRequestWrapper)((Object)o);
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        return this.principle.equals(that.principle);
    }

    public int hashCode() {
        int result = this.authType.hashCode();
        result = 31 * result + this.principle.hashCode();
        return result;
    }

    private class DelegatingPrinciple
    implements Principal {
        private String username;

        private DelegatingPrinciple(String username) {
            this.username = username;
        }

        @Override
        public String getName() {
            return this.username;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DelegatingPrinciple)) {
                return false;
            }
            DelegatingPrinciple that = (DelegatingPrinciple)o;
            return this.username.equals(that.username);
        }

        @Override
        public int hashCode() {
            return this.username.hashCode();
        }

        @Override
        public String toString() {
            return "DelegatingPrinciple{username='" + this.username + '\'' + '}';
        }
    }
}

