/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.auth.exception.IllegalUsernameException;

public class AuthManager
extends LifecycleAdapter {
    private final AuthenticationStrategy authStrategy;
    private final UserRepository users;
    private final boolean authEnabled;

    public AuthManager(UserRepository users, AuthenticationStrategy authStrategy, boolean authEnabled) {
        this.users = users;
        this.authStrategy = authStrategy;
        this.authEnabled = authEnabled;
    }

    public AuthManager(UserRepository users, AuthenticationStrategy authStrategy) {
        this(users, authStrategy, true);
    }

    public AuthManager(UserRepository users, Clock clock, boolean authEnabled) {
        this(users, new RateLimitedAuthenticationStrategy(clock, 3), authEnabled);
    }

    public void start() throws Throwable {
        if (this.authEnabled && this.users.numberOfUsers() == 0) {
            this.newUser("neo4j", "neo4j", true);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        if (user == null) {
            return AuthenticationResult.FAILURE;
        }
        AuthenticationResult result = this.authStrategy.authenticate(user, password);
        if (result != AuthenticationResult.SUCCESS) {
            return result;
        }
        if (user.passwordChangeRequired()) {
            return AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        return AuthenticationResult.SUCCESS;
    }

    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, IllegalUsernameException {
        this.assertAuthEnabled();
        this.assertValidName(username);
        User user = new User.Builder().withName(username).withCredentials(Credential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        this.users.create(user);
        return user;
    }

    public boolean deleteUser(String username) throws IOException {
        this.assertAuthEnabled();
        User user = this.users.findByName(username);
        return user != null && this.users.delete(user);
    }

    public User getUser(String username) {
        this.assertAuthEnabled();
        return this.users.findByName(username);
    }

    public User setPassword(String username, String password) throws IOException {
        this.assertAuthEnabled();
        User existingUser = this.users.findByName(username);
        if (existingUser == null) {
            return null;
        }
        if (existingUser.credentials().matchesPassword(password)) {
            return existingUser;
        }
        try {
            User updatedUser = existingUser.augment().withCredentials(Credential.forPassword(password)).withRequiredPasswordChange(false).build();
            this.users.update(existingUser, updatedUser);
            return updatedUser;
        }
        catch (ConcurrentModificationException e) {
            return this.setPassword(username, password);
        }
    }

    private void assertAuthEnabled() {
        if (!this.authEnabled) {
            throw new IllegalStateException("Auth not enabled");
        }
    }

    private void assertValidName(String name) {
        if (!this.users.isValidName(name)) {
            throw new IllegalArgumentException("User name contains illegal characters. Please use simple ascii characters and numbers.");
        }
    }
}

