/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.guard;

import java.io.IOException;
import java.util.Timer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardException;

public class GuardingRequestFilter
implements Filter {
    private final Guard guard;
    private final long timeout;
    private final Timer timer = new Timer();

    public GuardingRequestFilter(Guard guard, long timeout) {
        this.guard = guard;
        this.timeout = timeout;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            long timeLimit = this.getTimeLimit(request);
            if (timeLimit <= 0L) {
                chain.doFilter(req, res);
            } else {
                this.guard.startTimeout(timeLimit);
                try {
                    chain.doFilter(req, res);
                }
                catch (GuardException e) {
                    response.setStatus(408);
                }
                finally {
                    this.guard.stop();
                }
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
        this.timer.cancel();
    }

    private long getTimeLimit(HttpServletRequest request) {
        long timeLimit = this.timeout;
        String headerValue = request.getHeader("max-execution-time");
        if (headerValue != null) {
            long maxHeader = Long.parseLong(headerValue);
            if (timeLimit < 0L || maxHeader > 0L && maxHeader < timeLimit) {
                return maxHeader;
            }
        }
        return timeLimit;
    }
}

