/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.neo4j.server.rest.domain.URIHelper;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public abstract class IndexRepresentation
extends MappingRepresentation
implements EntityRepresentation {
    private final String name;
    private final Map<String, String> type;

    public IndexRepresentation(String name, Map<String, String> type) {
        super(RepresentationType.INDEX);
        this.name = name;
        this.type = type;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putUriTemplate("template", this.path() + "{key}/{value}");
        for (Map.Entry<String, String> pair : this.type.entrySet()) {
            serializer.putString(pair.getKey(), pair.getValue());
        }
    }

    public String relativeUriFor(String key, String value, long entityId) {
        return this.path() + URIHelper.encode(key) + "/" + URIHelper.encode(value) + "/" + Long.toString(entityId);
    }

    @Override
    public ValueRepresentation selfUri() {
        return ValueRepresentation.uri((String)this.path());
    }

    protected String path() {
        return "index/" + this.propertyContainerType() + "/" + URIHelper.encode(this.name) + "/";
    }

    protected abstract String propertyContainerType();
}

