/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.BaseServerConfigLoader;
import org.neo4j.server.configuration.ConfigWrappingConfiguration;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

@Deprecated
public interface ConfigurationBuilder {
    public Config configuration();

    public Map<String, String> getDatabaseTuningProperties();

    public static class ConfigWrappingConfigurator
    extends Configurator.Adapter {
        private Config config;

        public ConfigWrappingConfigurator(Config config) {
            this.config = config;
        }

        @Override
        public Configuration configuration() {
            return new ConfigWrappingConfiguration(this.config);
        }

        @Override
        public Map<String, String> getDatabaseTuningProperties() {
            return this.config.getParams();
        }

        @Override
        public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
            return (List)this.config.get(ServerSettings.third_party_packages);
        }
    }

    public static class ConfiguratorWrappingConfigurationBuilder
    implements ConfigurationBuilder {
        private final Config serverConfig;
        private final Map<String, String> dbProperties;

        public ConfiguratorWrappingConfigurationBuilder(Configurator configurator) {
            HashMap<String, String> serverProperties = new HashMap<String, String>();
            Configuration oldConfiguration = configurator.configuration();
            Iterator keys = oldConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                serverProperties.put(key, oldConfiguration.getProperty(key).toString());
            }
            serverProperties.put(ServerSettings.third_party_packages.name(), ConfiguratorWrappingConfigurationBuilder.toStringForThirdPartyPackageProperty(configurator.getThirdpartyJaxRsPackages()));
            this.serverConfig = new Config(serverProperties, BaseServerConfigLoader.getDefaultSettingsClasses());
            this.dbProperties = configurator.getDatabaseTuningProperties();
        }

        @Override
        public Config configuration() {
            return this.serverConfig;
        }

        @Override
        public Map<String, String> getDatabaseTuningProperties() {
            return this.dbProperties;
        }

        public static String toStringForThirdPartyPackageProperty(List<ThirdPartyJaxRsPackage> extensions) {
            String propertyString = "";
            int packageCount = extensions.size();
            if (packageCount == 0) {
                return propertyString;
            }
            ThirdPartyJaxRsPackage jaxRsPackage = null;
            for (int i = 0; i < packageCount - 1; ++i) {
                jaxRsPackage = extensions.get(i);
                propertyString = propertyString + jaxRsPackage.getPackageName() + "=" + jaxRsPackage.getMountPoint() + ",";
            }
            jaxRsPackage = extensions.get(packageCount - 1);
            propertyString = propertyString + jaxRsPackage.getPackageName() + "=" + jaxRsPackage.getMountPoint();
            return propertyString;
        }
    }
}

