(function(define){
define(function(){return function(vars){
with(vars||{}) {
return "<div class=\"sidebar\"><h1 class=\"pad\">Index management</h1><p class=\"pad\">This interface lets you list, create and remove indexes from your database.</p><p class=\"pad\">Note that index creation here is provided for testing purposes, and is only capable of creating default indexes. To create indexes with more complex configurations, please use your Neo4j REST client of choice.</p><p class=\"pad\">Note: You can query your indexes through the data browser, see \"syntax help\" below the search bar there.</p><div class=\"foldout\"><h2><a href=\"#\" class=\"foldout_trigger\">More about indexes</a></h2><div class=\"foldout_content pad\"><p>Neo4j has two types of indexes, node and relationship indexes. With node indexes you index and find nodes, and with relationship indexes you do the same for relationships.</p><p>Each index has a provider, which is the underlying implementation handling that index. The default provider is lucene, but you can create your own index provides if you like.</p><p>Neo4j indexes take key/value/object triplets (\"object\" being a node or a relationship), it will index the key/value pair, and associate this with the object provided. After you have indexed a set of key/value/object triplets, you can query the index and get back objects that where indexed with key/value pairs matching your query.</p><p>For instance, if you have \"User\" nodes in your database, and want to rapidly find them by username or email, you could create a node index named \"Users\", and for each user index username and email. With the default lucene configuration, you can then search the \"Users\" index with a query like: \"username:bob OR email:bob@gmail.com\".</p><p>You can use the data browser to query your indexes this way, the syntax for the above query is \"node:index:Users:username:bob OR email:bob@gmail.com\".</p></div></div></div><div class=\"workarea with-sidebar\"><div class=\"span-half no-margin node-indexes-wrap\"><div class=\"pad\"><h2>Node indexes</h2></div><div class=\"headline-bar pad\"><ul class=\"button-bar\"><li><input type=\"text\" value=\"New node index\" id=\"create-node-index-name\" /></li><li><button class=\"create-node-index button\">Create</button></li></ul><div class=\"break\"></div></div><table cellspacing=\"0\" class=\"data-table\" id=\"node-indexes\"></table></div><div class=\"span-half last no-margin rel-indexes-wrap\"><div class=\"pad\"><h2>Relationship indexes</h2></div><div class=\"headline-bar pad\"><ul class=\"button-bar\"><li><input type=\"text\" value=\"New relationship index\" id=\"create-rel-index-name\" /></li><li><button class=\"create-rel-index button\">Create</button></li></ul><div class=\"break\"></div></div><table cellspacing=\"0\" class=\"data-table\" id=\"rel-indexes\"></table></div></div>"; 
}};
});})(typeof define=="function"?
define:
function(factory){module.exports=factory.apply(this, deps.map(require));});
