/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.InvalidSemanticsException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransactionTerminationHandle;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.InternalBeginTransactionError;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.web.QuerySessionProvider;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandle
implements TransactionTerminationHandle {
    private final TransitionalPeriodTransactionMessContainer txManagerFacade;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final Log log;
    private final long id;
    private final QuerySessionProvider sessionFactory;
    private TransitionalTxManagementKernelTransaction context;

    public TransactionHandle(TransitionalPeriodTransactionMessContainer txManagerFacade, QueryExecutionEngine engine, TransactionRegistry registry, TransactionUriScheme uriScheme, LogProvider logProvider, QuerySessionProvider sessionFactory) {
        this.txManagerFacade = txManagerFacade;
        this.engine = engine;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.log = logProvider.getLog(this.getClass());
        this.id = registry.begin(this);
        this.sessionFactory = sessionFactory;
    }

    public URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StatementDeserializer statements, ExecutionResultSerializer output, HttpServletRequest request) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            output.transactionCommitUri(this.uriScheme.txCommitUri(this.id));
            this.ensureActiveTransaction();
            this.execute(statements, output, errors, request);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    @Override
    public boolean terminate() {
        if (this.context != null) {
            this.context.terminate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(StatementDeserializer statements, ExecutionResultSerializer output, boolean pristine, HttpServletRequest request) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            try {
                StatementExecutionStrategy executionStrategy = this.selectExecutionStrategy(statements, pristine, errors);
                switch (executionStrategy) {
                    case EXECUTE_STATEMENT_USING_PERIODIC_COMMIT: {
                        this.executePeriodicCommitStatement(statements, output, errors, request);
                        return;
                    }
                    case EXECUTE_STATEMENT: {
                        this.ensureActiveTransaction();
                        this.executeStatements(statements, output, errors, request);
                        this.closeContextAndCollectErrors(errors);
                        return;
                    }
                    case SKIP_EXECUTE_STATEMENT: {
                        IteratorUtil.addToCollection(statements.errors(), errors);
                        return;
                    }
                }
                return;
            }
            finally {
                this.registry.forget(this.id);
            }
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
            return;
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    private StatementExecutionStrategy selectExecutionStrategy(StatementDeserializer statements, boolean pristine, List<Neo4jError> errors) {
        try {
            if (pristine) {
                Statement peek = (Statement)statements.peek();
                if (peek == null) {
                    return StatementExecutionStrategy.SKIP_EXECUTE_STATEMENT;
                }
                if (this.engine.isPeriodicCommit(peek.statement())) {
                    return StatementExecutionStrategy.EXECUTE_STATEMENT_USING_PERIODIC_COMMIT;
                }
                return StatementExecutionStrategy.EXECUTE_STATEMENT;
            }
            return StatementExecutionStrategy.EXECUTE_STATEMENT;
        }
        catch (CypherException e) {
            errors.add(new Neo4jError(e.status(), e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ExecutionResultSerializer output) {
        LinkedList<Neo4jError> errors = new LinkedList<Neo4jError>();
        try {
            this.ensureActiveTransaction();
            this.rollback(errors);
        }
        catch (InternalBeginTransactionError e) {
            errors.add(e.toNeo4jError());
        }
        finally {
            output.errors(errors);
            output.finish();
        }
    }

    public void forceRollback() throws TransactionFailureException {
        this.context.resumeSinceTransactionsAreStillThreadBound();
        this.context.rollback();
    }

    private void ensureActiveTransaction() throws InternalBeginTransactionError {
        if (this.context == null) {
            try {
                this.context = this.txManagerFacade.newTransaction();
            }
            catch (RuntimeException e) {
                this.log.error("Failed to start transaction.", (Throwable)e);
                throw new InternalBeginTransactionError(e);
            }
        } else {
            this.context.resumeSinceTransactionsAreStillThreadBound();
        }
    }

    private void execute(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors, HttpServletRequest request) {
        this.executeStatements(statements, output, errors, request);
        if (Neo4jError.shouldRollBackOn(errors)) {
            this.rollback(errors);
        } else {
            this.context.suspendSinceTransactionsAreStillThreadBound();
            long lastActiveTimestamp = this.registry.release(this.id, this);
            output.transactionStatus(lastActiveTimestamp);
        }
    }

    private void closeContextAndCollectErrors(List<Neo4jError> errors) {
        if (errors.isEmpty()) {
            try {
                this.context.commit();
            }
            catch (Exception e) {
                this.log.error("Failed to commit transaction.", (Throwable)e);
                errors.add(new Neo4jError((Status)Status.Transaction.CouldNotCommit, e));
            }
        } else {
            try {
                this.context.rollback();
            }
            catch (Exception e) {
                this.log.error("Failed to rollback transaction.", (Throwable)e);
                errors.add(new Neo4jError((Status)Status.Transaction.CouldNotRollback, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(List<Neo4jError> errors) {
        try {
            this.context.rollback();
        }
        catch (Exception e) {
            this.log.error("Failed to rollback transaction.", (Throwable)e);
            errors.add(new Neo4jError((Status)Status.Transaction.CouldNotRollback, e));
        }
        finally {
            this.registry.forget(this.id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeStatements(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors, HttpServletRequest request) {
        try {
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                try {
                    Result result = this.engine.executeQuery(statement.statement(), statement.parameters(), this.sessionFactory.create(request));
                    output.statementResult(result, statement.includeStats(), statement.resultDataContents());
                    output.notifications(result.getNotifications());
                }
                catch (CypherException | KernelException e) {
                    errors.add(new Neo4jError(((Status.HasStatus)e).status(), e));
                    break;
                }
                catch (QueryExecutionException e) {
                    if (e.getCause() instanceof Status.HasStatus) {
                        errors.add(new Neo4jError(((Status.HasStatus)e.getCause()).status(), e));
                        break;
                    }
                    errors.add(new Neo4jError((Status)Status.Statement.ExecutionFailure, e));
                    break;
                }
                catch (DeadlockDetectedException e) {
                    errors.add(new Neo4jError((Status)Status.Transaction.DeadlockDetected, e));
                }
                catch (IOException e) {
                    errors.add(new Neo4jError((Status)Status.Network.UnknownFailure, e));
                    break;
                }
                catch (Exception e) {
                    errors.add(new Neo4jError((Status)Status.Statement.ExecutionFailure, e));
                    break;
                }
            }
            IteratorUtil.addToCollection(statements.errors(), errors);
            return;
        }
        catch (Throwable e) {
            errors.add(new Neo4jError((Status)Status.General.UnknownFailure, e));
        }
    }

    private void executePeriodicCommitStatement(StatementDeserializer statements, ExecutionResultSerializer output, List<Neo4jError> errors, HttpServletRequest request) {
        try {
            try {
                Statement statement = (Statement)statements.next();
                if (statements.hasNext()) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Cannot execute another statement after executing PERIODIC COMMIT statement in the same transaction"));
                }
                Result result = this.engine.executeQuery(statement.statement(), statement.parameters(), this.sessionFactory.create(request));
                this.ensureActiveTransaction();
                output.statementResult(result, statement.includeStats(), statement.resultDataContents());
                output.notifications(result.getNotifications());
                this.closeContextAndCollectErrors(errors);
            }
            catch (CypherException | KernelException e) {
                errors.add(new Neo4jError(((Status.HasStatus)e).status(), e));
            }
            catch (DeadlockDetectedException e) {
                errors.add(new Neo4jError((Status)Status.Transaction.DeadlockDetected, e));
            }
            catch (IOException e) {
                errors.add(new Neo4jError((Status)Status.Network.UnknownFailure, e));
            }
            catch (Exception e) {
                errors.add(new Neo4jError((Status)Status.Statement.ExecutionFailure, e));
            }
            IteratorUtil.addToCollection(statements.errors(), errors);
        }
        catch (Throwable e) {
            errors.add(new Neo4jError((Status)Status.General.UnknownFailure, e));
        }
    }

    static enum StatementExecutionStrategy {
        EXECUTE_STATEMENT_USING_PERIODIC_COMMIT,
        EXECUTE_STATEMENT,
        SKIP_EXECUTE_STATEMENT;

    }
}

