/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.Utf8Generator;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.StreamingFormat;

public class StreamingJsonFormat
extends RepresentationFormat
implements StreamingFormat {
    private final JsonFactory factory = this.createJsonFactory();

    public StreamingJsonFormat() {
        super(MEDIA_TYPE);
    }

    private JsonFactory createJsonFactory() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getSerializationConfig().disable(SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE);
        JsonFactory factory = new JsonFactory((ObjectCodec)objectMapper){

            protected JsonGenerator _createUTF8JsonGenerator(OutputStream out, IOContext ctxt) throws IOException {
                int bufferSize = 8192;
                Utf8Generator gen = new Utf8Generator(ctxt, this._generatorFeatures, this._objectCodec, out, new byte[8192], 0, true);
                if (this._characterEscapes != null) {
                    gen.setCharacterEscapes(this._characterEscapes);
                }
                return gen;
            }
        };
        factory.disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
        return factory;
    }

    @Override
    public StreamingRepresentationFormat writeTo(OutputStream output) {
        try {
            JsonGenerator g = this.factory.createJsonGenerator(output);
            return new StreamingRepresentationFormat(g, (InputFormat)this);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected ListWriter serializeList(String type) {
        throw new UnsupportedOperationException();
    }

    protected String complete(ListWriter serializer) {
        throw new UnsupportedOperationException();
    }

    protected MappingWriter serializeMapping(String type) {
        throw new UnsupportedOperationException();
    }

    protected String complete(MappingWriter serializer) {
        throw new UnsupportedOperationException();
    }

    protected String serializeValue(String type, Object value) {
        throw new UnsupportedOperationException();
    }

    private boolean empty(String input) {
        return input == null || "".equals(input.trim());
    }

    public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
        if (this.empty(input)) {
            return DefaultFormat.validateKeys(Collections.emptyMap(), requiredKeys);
        }
        try {
            return DefaultFormat.validateKeys(JsonHelper.jsonToMap(this.stripByteOrderMark(input)), requiredKeys);
        }
        catch (Exception ex) {
            throw new BadInputException((Throwable)ex);
        }
    }

    public List<Object> readList(String input) {
        throw new UnsupportedOperationException("Not implemented: JsonInput.readList()");
    }

    public Object readValue(String input) throws BadInputException {
        if (this.empty(input)) {
            return Collections.emptyMap();
        }
        try {
            return JsonHelper.assertSupportedPropertyValue(JsonHelper.readJson(this.stripByteOrderMark(input)));
        }
        catch (JsonParseException ex) {
            throw new BadInputException((Throwable)ex);
        }
    }

    public URI readUri(String input) throws BadInputException {
        try {
            return new URI(this.readValue(input).toString());
        }
        catch (URISyntaxException e) {
            throw new BadInputException((Throwable)e);
        }
    }

    private String stripByteOrderMark(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\ufeff') {
            return string.substring(1);
        }
        return string;
    }

    public static class StreamingRepresentationFormat
    extends RepresentationFormat {
        private final JsonGenerator g;
        private final InputFormat inputFormat;

        public StreamingRepresentationFormat(JsonGenerator g, InputFormat inputFormat) {
            super(StreamingFormat.MEDIA_TYPE);
            this.g = g;
            this.inputFormat = inputFormat;
        }

        public StreamingRepresentationFormat usePrettyPrinter() {
            this.g.useDefaultPrettyPrinter();
            return this;
        }

        protected String serializeValue(String type, Object value) {
            try {
                this.g.writeObject(value);
                return null;
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        protected ListWriter serializeList(String type) {
            return new StreamingListWriter(this.g);
        }

        public MappingWriter serializeMapping(String type) {
            return new StreamingMappingWriter(this.g);
        }

        protected String complete(ListWriter serializer) {
            this.flush();
            return null;
        }

        protected String complete(MappingWriter serializer) {
            this.flush();
            return null;
        }

        private void flush() {
            try {
                this.g.flush();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public Object readValue(String input) throws BadInputException {
            return this.inputFormat.readValue(input);
        }

        public Map<String, Object> readMap(String input, String ... requiredKeys) throws BadInputException {
            return this.inputFormat.readMap(input, requiredKeys);
        }

        public List<Object> readList(String input) throws BadInputException {
            return this.inputFormat.readList(input);
        }

        public URI readUri(String input) throws BadInputException {
            return this.inputFormat.readUri(input);
        }

        public void complete() {
            try {
                this.g.flush();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    private static class StreamingListWriter
    extends ListWriter {
        private final JsonGenerator g;

        public StreamingListWriter(JsonGenerator g) {
            this.g = g;
            try {
                g.writeStartArray();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public StreamingListWriter(JsonGenerator g, String key) {
            this.g = g;
            try {
                g.writeArrayFieldStart(key);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public MappingWriter newMapping(String type) {
            return new StreamingMappingWriter(this.g);
        }

        public ListWriter newList(String type) {
            return new StreamingListWriter(this.g);
        }

        public void writeValue(String type, Object value) {
            try {
                this.g.writeObject(value);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public void done() {
            try {
                this.g.writeEndArray();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    private static class StreamingMappingWriter
    extends MappingWriter {
        private final JsonGenerator g;

        public StreamingMappingWriter(JsonGenerator g) {
            this.g = g;
            try {
                g.writeStartObject();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public StreamingMappingWriter(JsonGenerator g, String key) {
            this.g = g;
            try {
                g.writeObjectFieldStart(key);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public MappingWriter newMapping(String type, String key) {
            return new StreamingMappingWriter(this.g, key);
        }

        public ListWriter newList(String type, String key) {
            return new StreamingListWriter(this.g, key);
        }

        public void writeValue(String type, String key, Object value) {
            try {
                this.g.writeObjectField(key, value);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }

        public void done() {
            try {
                this.g.writeEndObject();
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

