/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.WrapFactory;
import org.neo4j.server.scripting.UserScriptClassWhiteList;
import org.neo4j.server.scripting.javascript.WhiteListClassShutter;
import org.neo4j.server.scripting.javascript.WhiteListJavaWrapper;

public class GlobalJavascriptInitializer {
    private static Mode initializationMode;

    public static synchronized void initialize(Mode requestedMode) {
        ContextFactory contextFactory;
        if (initializationMode != null) {
            if (initializationMode == requestedMode) {
                return;
            }
            throw new RuntimeException("Cannot initialize javascript context twice, system is currently initialized as: '" + initializationMode.name() + "'.");
        }
        initializationMode = requestedMode;
        switch (requestedMode) {
            case UNSAFE: {
                contextFactory = new ContextFactory(){

                    protected Context makeContext() {
                        Context cx = super.makeContext();
                        cx.setLanguageVersion(170);
                        cx.setOptimizationLevel(4);
                        return cx;
                    }
                };
                break;
            }
            default: {
                contextFactory = new ContextFactory(){

                    protected Context makeContext() {
                        Context cx = super.makeContext();
                        WhiteListClassShutter shutter = new WhiteListClassShutter(UserScriptClassWhiteList.getWhiteList());
                        cx.setLanguageVersion(170);
                        cx.setOptimizationLevel(4);
                        cx.setClassShutter((ClassShutter)shutter);
                        cx.setWrapFactory((WrapFactory)new WhiteListJavaWrapper(shutter));
                        return cx;
                    }
                };
            }
        }
        ContextFactory.initGlobal((ContextFactory)contextFactory);
    }

    public static enum Mode {
        SANDBOXED,
        UNSAFE;

    }
}

