/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;

public class Neo4jJsonCodec
extends ObjectMapper {
    public Neo4jJsonCodec() {
        this.getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE});
    }

    public void writeValue(JsonGenerator out, Object value) throws IOException {
        if (value instanceof PropertyContainer) {
            this.writePropertyContainer(out, (PropertyContainer)value);
        } else if (value instanceof Path) {
            this.writePath(out, ((Path)value).iterator());
        } else if (value instanceof Iterable) {
            this.writeIterator(out, ((Iterable)value).iterator());
        } else if (value instanceof byte[]) {
            this.writeByteArray(out, (byte[])value);
        } else if (value instanceof Map) {
            this.writeMap(out, (Map)value);
        } else {
            super.writeValue(out, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMap(JsonGenerator out, Map value) throws IOException {
        out.writeStartObject();
        try {
            Set set = value.entrySet();
            for (Map.Entry e : set) {
                Object key = e.getKey();
                out.writeFieldName(key == null ? "null" : key.toString());
                this.writeValue(out, e.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIterator(JsonGenerator out, Iterator value) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writeValue(out, value.next());
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePath(JsonGenerator out, Iterator<PropertyContainer> value) throws IOException {
        out.writeStartArray();
        try {
            while (value.hasNext()) {
                this.writePropertyContainer(out, value.next());
            }
        }
        finally {
            out.writeEndArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertyContainer(JsonGenerator out, PropertyContainer value) throws IOException {
        out.writeStartObject();
        try {
            for (Map.Entry property : value.getAllProperties().entrySet()) {
                out.writeObjectField((String)property.getKey(), property.getValue());
            }
        }
        finally {
            out.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteArray(JsonGenerator out, byte[] bytes) throws IOException {
        out.writeStartArray();
        try {
            for (byte b : bytes) {
                out.writeNumber((int)b);
            }
        }
        finally {
            out.writeEndArray();
        }
    }
}

