/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ScheduledJob {
    private final Timer timer;

    public ScheduledJob(final Runnable job, String name, long delay, long period, LogProvider logProvider) {
        this.timer = new Timer(name);
        final Log log = logProvider.getLog(this.getClass());
        TimerTask runJob = new TimerTask(){

            @Override
            public void run() {
                try {
                    job.run();
                }
                catch (Exception e) {
                    log.warn("Unable to execute scheduled job", (Throwable)e);
                }
            }
        };
        this.timer.scheduleAtFixedRate(runJob, delay, period);
    }

    public void cancel() {
        this.timer.cancel();
    }
}

